/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.cn.smart.HMMChineseTokenizer;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.util.IOUtils;

public final class SmartChineseAnalyzer
extends Analyzer {
    private final CharArraySet stopWords;

    public SmartChineseAnalyzer() {
        this(true);
    }

    public SmartChineseAnalyzer(boolean useDefaultStopWords) {
        this.stopWords = useDefaultStopWords ? DefaultSetHolder.DEFAULT_STOP_SET : CharArraySet.EMPTY_SET;
    }

    @Override
    public Analyzer.TokenStreamComponents createComponents(String fieldName) {
        HMMChineseTokenizer tokenizer;
        TokenStream result = tokenizer = new HMMChineseTokenizer();
        result = new PorterStemFilter(result);
        if (!this.stopWords.isEmpty()) {
            result = new StopFilter(result, this.stopWords);
        }
        return new Analyzer.TokenStreamComponents(tokenizer, result);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        static CharArraySet loadDefaultStopWordSet() throws IOException {
            return CharArraySet.unmodifiableSet(WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(SmartChineseAnalyzer.class.getResourceAsStream("stopwords.txt"), "stopwords.txt"), "//"));
        }

        static {
            try {
                DEFAULT_STOP_SET = DefaultSetHolder.loadDefaultStopWordSet();
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

