/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.boxes;

import com.whitemagicsoftware.tex.boxes.Box;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public final class OverUnderBox
extends Box {
    private final Box base;
    private final Box del;
    private final Box script;
    private final float kern;
    private final boolean over;

    public OverUnderBox(Box b, Box d, Box script, float kern, boolean over) {
        this.base = b;
        this.del = d;
        this.script = script;
        this.kern = kern;
        this.over = over;
        float kh = script == null ? 0.0f : script.height + script.depth + kern;
        this.width = b.getWidth();
        this.height = b.height + (over ? d.getWidth() : 0.0f) + (over && script != null ? kh : 0.0f);
        this.depth = b.depth + (over ? 0.0f : d.getWidth()) + (!over && script == null ? 0.0f : kh);
    }

    @Override
    public void draw(Graphics2D g, float x, float y) {
        AffineTransform oldAt;
        double transY;
        double transX;
        this.base.draw(g, x, y);
        float yVar = y - this.base.height;
        if (this.over) {
            transX = x + this.del.getWidth() / 2.0f;
            transY = yVar - this.del.getWidth() / 2.0f;
            oldAt = g.getTransform();
            g.translate(transX, transY);
            g.rotate(1.5707963267948966);
            this.del.draw(g, -this.del.getWidth() / 2.0f, -this.del.depth + this.del.getWidth() / 2.0f);
            g.setTransform(oldAt);
            yVar -= this.del.getWidth();
            if (this.script != null) {
                this.script.draw(g, x, yVar - this.kern - this.script.depth);
            }
        }
        yVar = y + this.base.depth;
        if (!this.over) {
            transX = x + this.del.getWidth() / 2.0f;
            transY = (yVar += this.del.getWidth()) - this.del.getWidth() / 2.0f;
            oldAt = g.getTransform();
            g.translate(transX, transY);
            g.rotate(1.5707963267948966);
            this.del.draw(g, -this.del.getWidth() / 2.0f, -this.del.depth + this.del.getWidth() / 2.0f);
            g.setTransform(oldAt);
            if (this.script != null) {
                this.script.draw(g, x, yVar + this.kern + this.script.height);
            }
        }
    }

    @Override
    public int getLastFontId() {
        return this.base.getLastFontId();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{, kern=" + this.kern + ", over=" + this.over + "}";
    }
}

