/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.jdom2.Attribute;
import org.jdom2.AttributeList;
import org.jdom2.Content;
import org.jdom2.ContentList;
import org.jdom2.DocType;
import org.jdom2.IllegalAddException;
import org.jdom2.IllegalNameException;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.Verifier;
import org.jdom2.filter.ElementFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends Content
implements Parent {
    protected String name;
    protected Namespace namespace;
    transient List<Namespace> additionalNamespaces = null;
    transient AttributeList attributes = null;
    transient ContentList content = new ContentList(this);

    protected Element() {
        super(Content.CType.Element);
    }

    public Element(String name, Namespace namespace) {
        super(Content.CType.Element);
        this.setName(name);
        this.setNamespace(namespace);
    }

    public String getName() {
        return this.name;
    }

    public Element setName(String name) {
        String reason = Verifier.checkElementName(name);
        if (reason != null) {
            throw new IllegalNameException(name, "element", reason);
        }
        this.name = name;
        return this;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Element setNamespace(Namespace namespace) {
        String reason;
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        if (this.additionalNamespaces != null && (reason = Verifier.checkNamespaceCollision(namespace, this.getAdditionalNamespaces())) != null) {
            throw new IllegalAddException(this, namespace, reason);
        }
        if (this.hasAttributes()) {
            for (Attribute a : this.getAttributes()) {
                String reason2 = Verifier.checkNamespaceCollision(namespace, a);
                if (reason2 == null) continue;
                throw new IllegalAddException(this, namespace, reason2);
            }
        }
        this.namespace = namespace;
        return this;
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public String getQualifiedName() {
        if ("".equals(this.namespace.getPrefix())) {
            return this.getName();
        }
        return this.namespace.getPrefix() + ':' + this.name;
    }

    public boolean addNamespaceDeclaration(Namespace additionalNamespace) {
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList<Namespace>(5);
        }
        for (Namespace ns : this.additionalNamespaces) {
            if (ns != additionalNamespace) continue;
            return false;
        }
        String reason = Verifier.checkNamespaceCollision(additionalNamespace, this);
        if (reason != null) {
            throw new IllegalAddException(this, additionalNamespace, reason);
        }
        return this.additionalNamespaces.add(additionalNamespace);
    }

    public List<Namespace> getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    public Element addContent(Content child) {
        this.content.add(child);
        return this;
    }

    public boolean isAncestor(Element element) {
        Parent p = element.getParent();
        while (p instanceof Element) {
            if (p == this) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public boolean hasAdditionalNamespaces() {
        return this.additionalNamespaces != null && !this.additionalNamespaces.isEmpty();
    }

    AttributeList getAttributeList() {
        if (this.attributes == null) {
            this.attributes = new AttributeList(this);
        }
        return this.attributes;
    }

    public List<Attribute> getAttributes() {
        return this.getAttributeList();
    }

    public String getAttributeValue(String attname) {
        if (this.attributes == null) {
            return null;
        }
        return this.getAttributeValue(attname, Namespace.NO_NAMESPACE);
    }

    public String getAttributeValue(String attname, Namespace ns) {
        if (this.attributes == null) {
            return null;
        }
        return this.getAttributeValue(attname, ns, null);
    }

    public String getAttributeValue(String attname, Namespace ns, String def) {
        if (this.attributes == null) {
            return def;
        }
        Attribute attribute = this.getAttributeList().get(attname, ns);
        if (attribute == null) {
            return def;
        }
        return attribute.getValue();
    }

    public Element setAttribute(Attribute attribute) {
        this.getAttributeList().add(attribute);
        return this;
    }

    public String toString() {
        StringBuilder stringForm = new StringBuilder(64).append("[Element: <").append(this.getQualifiedName());
        String nsuri = this.getNamespaceURI();
        if (!"".equals(nsuri)) {
            stringForm.append(" [Namespace: ").append(nsuri).append("]");
        }
        stringForm.append("/>]");
        return stringForm.toString();
    }

    @Override
    public Element clone() {
        int i;
        Element element = (Element)super.clone();
        element.content = new ContentList(element);
        AttributeList attributeList = element.attributes = this.attributes == null ? null : new AttributeList(element);
        if (this.attributes != null) {
            for (i = 0; i < this.attributes.size(); ++i) {
                Attribute attribute = this.attributes.get(i);
                element.attributes.add(attribute.clone());
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList<Namespace>(this.additionalNamespaces);
        }
        for (i = 0; i < this.content.size(); ++i) {
            Content c = this.content.get(i);
            element.content.add(c.clone());
        }
        return element;
    }

    public List<Element> getChildren() {
        return this.content.getView(new ElementFilter());
    }

    public List<Element> getChildren(String cname) {
        return this.getChildren(cname, Namespace.NO_NAMESPACE);
    }

    public List<Element> getChildren(String cname, Namespace ns) {
        return this.content.getView(new ElementFilter(cname, ns));
    }

    public Element getChild(String cname, Namespace ns) {
        List<Element> elements = this.content.getView(new ElementFilter(cname, ns));
        Iterator<Element> iter = elements.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public Element getChild(String cname) {
        return this.getChild(cname, Namespace.NO_NAMESPACE);
    }

    @Override
    public List<Namespace> getNamespacesInScope() {
        Element pnt;
        TreeMap<String, Namespace> namespaces = new TreeMap<String, Namespace>();
        namespaces.put(Namespace.XML_NAMESPACE.getPrefix(), Namespace.XML_NAMESPACE);
        namespaces.put(this.getNamespacePrefix(), this.getNamespace());
        if (this.additionalNamespaces != null) {
            for (Namespace namespace : this.getAdditionalNamespaces()) {
                if (namespaces.containsKey(namespace.getPrefix())) continue;
                namespaces.put(namespace.getPrefix(), namespace);
            }
        }
        if (this.attributes != null) {
            for (Attribute attribute : this.getAttributes()) {
                Namespace ns = attribute.getNamespace();
                if (Namespace.NO_NAMESPACE.equals(ns) || namespaces.containsKey(ns.getPrefix())) continue;
                namespaces.put(ns.getPrefix(), ns);
            }
        }
        if ((pnt = this.getParentElement()) != null) {
            for (Namespace ns : pnt.getNamespacesInScope()) {
                if (namespaces.containsKey(ns.getPrefix())) continue;
                namespaces.put(ns.getPrefix(), ns);
            }
        }
        if (pnt == null && !namespaces.containsKey("")) {
            namespaces.put(Namespace.NO_NAMESPACE.getPrefix(), Namespace.NO_NAMESPACE);
        }
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>(namespaces.size());
        arrayList.add(this.getNamespace());
        namespaces.remove(this.getNamespacePrefix());
        arrayList.addAll(namespaces.values());
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public void canContainContent(Content child, int index, boolean replace) throws IllegalAddException {
        if (child instanceof DocType) {
            throw new IllegalAddException("A DocType is not allowed except at the document level");
        }
    }
}

