/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.graphics;

import com.whitemagicsoftware.tex.graphics.AbstractGraphics2D;
import com.whitemagicsoftware.tex.graphics.NullDocumentBuilder;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SvgDomGraphics2D
extends AbstractGraphics2D {
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final DocumentBuilderFactory FACTORY_DOC = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder BUILDER_DOC;
    private static final StringBuilder sData;
    private static final String NAMESPACE = "http://www.w3.org/2000/svg";
    private static final String ATTR_NAME_VERSION = "version";
    private static final String ATTR_VALUE_VERSION = "1.1";
    private static final String ATTR_NAME_ID = "id";
    private static final String ATTR_NAME_X = "x";
    private static final String ATTR_NAME_Y = "y";
    private static final String ATTR_NAME_WIDTH = "width";
    private static final String ATTR_NAME_HEIGHT = "height";
    private static final String ATTR_NAME_TRANSFORM = "transform";
    private static final String ATTR_NAME_PATH_FILL_RULE = "fill-rule";
    private static final String ATTR_NAME_PATH_DATA = "d";
    private static final int DECIMALS_GEOMETRY = 4;
    private static final int DECIMALS_TRANSFORM = 6;
    private final float[] mCoords = new float[6];
    private String mTransform = "";
    private final Document mDocument = BUILDER_DOC.newDocument();
    private Element mRoot;

    @Override
    public void initialize(int w, int h) {
        this.reset();
        this.setDimensions(w, h);
    }

    @Override
    public void initialize(int id, int w, int h) {
        this.initialize(w, h);
        this.mRoot.setAttributeNS(null, ATTR_NAME_ID, Integer.toString(id));
    }

    private void reset() {
        if (this.mRoot != null) {
            this.mDocument.removeChild(this.mRoot);
        }
        this.mRoot = this.mDocument.createElementNS(NAMESPACE, "svg");
        this.mRoot.setAttributeNS(null, ATTR_NAME_VERSION, ATTR_VALUE_VERSION);
        this.mDocument.appendChild(this.mRoot);
    }

    private void setDimensions(int w, int h) {
        this.mRoot.setAttributeNS(null, ATTR_NAME_WIDTH, w + "px");
        this.mRoot.setAttributeNS(null, ATTR_NAME_HEIGHT, h + "px");
    }

    @Override
    public void draw(Shape shape) {
        Element e = this.mDocument.createElementNS(NAMESPACE, "g");
        this.mRoot.appendChild(e);
        if (!this.isIdentityTransform()) {
            e.setAttributeNS(null, ATTR_NAME_TRANSFORM, this.mTransform);
        }
        this.appendPath((Path2D)shape, e);
    }

    private void appendPath(Path2D path, Element parent) {
        Element e = this.mDocument.createElementNS(NAMESPACE, "path");
        parent.appendChild(e);
        if (path.getWindingRule() == 0) {
            e.setAttributeNS(null, ATTR_NAME_PATH_FILL_RULE, "evenodd");
        }
        PathIterator iterator = path.getPathIterator(null);
        while (!iterator.isDone()) {
            switch (iterator.currentSegment(this.mCoords)) {
                case 0: {
                    sData.append('M').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[0])).append(' ').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[1]));
                    break;
                }
                case 1: {
                    sData.append('L').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[0])).append(' ').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[1]));
                    break;
                }
                case 2: {
                    sData.append('Q').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[0])).append(' ').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[1])).append(' ').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[2])).append(' ').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[3]));
                    break;
                }
                case 3: {
                    sData.append('C').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[0])).append(' ').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[1])).append(' ').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[2])).append(' ').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[3])).append(' ').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[4])).append(' ').append(SvgDomGraphics2D.toGeometryPrecision(this.mCoords[5]));
                    break;
                }
                case 4: {
                    sData.append('Z');
                }
            }
            iterator.next();
        }
        e.setAttributeNS(null, ATTR_NAME_PATH_DATA, sData.toString());
        sData.setLength(0);
    }

    @Override
    public void fill(Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)shape;
            Element e = this.mDocument.createElementNS(NAMESPACE, "rect");
            this.mRoot.appendChild(e);
            e.setAttributeNS(null, ATTR_NAME_X, SvgDomGraphics2D.toGeometryPrecision(r.getX()));
            e.setAttributeNS(null, ATTR_NAME_Y, SvgDomGraphics2D.toGeometryPrecision(r.getY()));
            e.setAttributeNS(null, ATTR_NAME_WIDTH, SvgDomGraphics2D.toGeometryPrecision(r.getWidth()));
            e.setAttributeNS(null, ATTR_NAME_HEIGHT, SvgDomGraphics2D.toGeometryPrecision(r.getHeight()));
            if (!this.isIdentityTransform()) {
                e.setAttributeNS(null, ATTR_NAME_TRANSFORM, this.mTransform);
            }
        } else {
            this.draw(shape);
        }
    }

    @Override
    public void setTransform(AffineTransform at) {
        assert (at != null);
        super.setTransform(at);
        this.mTransform = this.toString(at);
    }

    public Document toDom() {
        return this.mDocument;
    }

    @Override
    public String toString() {
        String string;
        StringWriter writer = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(this.mDocument), new StreamResult(writer));
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return "";
            }
        }
        writer.close();
        return string;
    }

    static {
        try {
            FACTORY_DOC.setFeature(LOAD_EXTERNAL_DTD, false);
            BUILDER_DOC = FACTORY_DOC.newDocumentBuilder();
        }
        catch (Exception ex) {
            BUILDER_DOC = new NullDocumentBuilder();
        }
        sData = new StringBuilder(16384);
    }
}

