/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex;

import com.whitemagicsoftware.tex.Char;
import com.whitemagicsoftware.tex.CharFont;
import com.whitemagicsoftware.tex.Extension;
import com.whitemagicsoftware.tex.FontInfo;
import com.whitemagicsoftware.tex.Metrics;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.TeXFormula;
import com.whitemagicsoftware.tex.exceptions.SymbolMappingNotFoundException;
import com.whitemagicsoftware.tex.exceptions.TextStyleMappingNotFoundException;
import com.whitemagicsoftware.tex.parsers.DefaultTeXFontParser;
import java.util.Map;

public record DefaultTeXFont(float pointSize) implements TeXFont
{
    public static final int NO_EXTENSION = -1;
    public static final int NUMBERS = 0;
    public static final int CAPITALS = 1;
    public static final int SMALL = 2;
    public static final int UNICODE = 3;
    public static final int TOP = 0;
    public static final int MID = 1;
    public static final int REP = 2;
    public static final int BOT = 3;
    public static final int WIDTH = 0;
    public static final int HEIGHT = 1;
    public static final int DEPTH = 2;
    public static final int ITALIC = 3;
    private static final String[] defaultTextStyleMappings;
    private static final Map<String, CharFont[]> textStyleMappings;
    private static final Map<String, CharFont> symbolMappings;
    private static final Map<String, Float> parameters;
    private static final Map<String, Number> generalSettings;
    private static final FontInfo[] fontInfo;
    private static final int sMuFontId;
    private static final float sScriptFactor;
    private static final float sScriptScriptFactor;
    private static final int sSpaceFontId;

    @Override
    public float getAxisHeight(int style) {
        return this.getResizedParameter("axisheight", style);
    }

    @Override
    public float getBigOpSpacing1(int style) {
        return this.getResizedParameter("bigopspacing1", style);
    }

    @Override
    public float getBigOpSpacing2(int style) {
        return this.getResizedParameter("bigopspacing2", style);
    }

    @Override
    public float getBigOpSpacing3(int style) {
        return this.getResizedParameter("bigopspacing3", style);
    }

    @Override
    public float getBigOpSpacing4(int style) {
        return this.getResizedParameter("bigopspacing4", style);
    }

    @Override
    public float getBigOpSpacing5(int style) {
        return this.getResizedParameter("bigopspacing5", style);
    }

    @Override
    public float getDefaultRuleThickness(int style) {
        return this.getResizedParameter("defaultrulethickness", style);
    }

    @Override
    public float getDenom1(int style) {
        return this.getResizedParameter("denom1", style);
    }

    @Override
    public float getDenom2(int style) {
        return this.getResizedParameter("denom2", style);
    }

    @Override
    public float getSub1(int style) {
        return this.getResizedParameter("sub1", style);
    }

    @Override
    public float getSub2(int style) {
        return this.getResizedParameter("sub2", style);
    }

    @Override
    public float getSubDrop(int style) {
        return this.getResizedParameter("subdrop", style);
    }

    @Override
    public float getSup1(int style) {
        return this.getResizedParameter("sup1", style);
    }

    @Override
    public float getSup2(int style) {
        return this.getResizedParameter("sup2", style);
    }

    @Override
    public float getSup3(int style) {
        return this.getResizedParameter("sup3", style);
    }

    @Override
    public float getSupDrop(int style) {
        return this.getResizedParameter("supdrop", style);
    }

    @Override
    public float getNum1(int style) {
        return this.getResizedParameter("num1", style);
    }

    @Override
    public float getNum2(int style) {
        return this.getResizedParameter("num2", style);
    }

    @Override
    public float getNum3(int style) {
        return this.getResizedParameter("num3", style);
    }

    @Override
    public float getSpace(int style) {
        FontInfo info = this.getFontInfo(sSpaceFontId);
        return info.getSpace(this.getScaledSizeFactor(style));
    }

    private float getResizedParameter(String p, int style) {
        return DefaultTeXFont.getParameter(p) * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    private Char getChar(char c, CharFont[] cf, int style) {
        int kind = 1;
        int offset = c - 65;
        if (c >= '0' && c <= '9') {
            kind = 0;
            offset = c - 48;
        } else if (c >= 'a' && c <= 'z') {
            kind = 2;
            offset = c - 97;
        }
        if (cf[kind] == null) {
            return this.getDefaultChar(c, style);
        }
        return this.getChar(new CharFont((char)(cf[kind].c + offset), cf[kind].fontId), style);
    }

    @Override
    public Char getChar(char c, String textStyle, int style) throws TextStyleMappingNotFoundException {
        CharFont[] mapping = textStyleMappings.get(textStyle);
        if (mapping == null) {
            throw new TextStyleMappingNotFoundException(textStyle);
        }
        return this.getChar(c, mapping, style);
    }

    @Override
    public Char getChar(CharFont cf, int style) {
        float size = DefaultTeXFont.getSizeFactor(style);
        return new Char(cf.c, cf.fontId, this.getMetrics(cf, size));
    }

    @Override
    public Char getChar(String symbolName, int style) throws SymbolMappingNotFoundException {
        CharFont charFont = symbolMappings.get(symbolName);
        if (charFont == null) {
            throw new SymbolMappingNotFoundException(symbolName);
        }
        return this.getChar(charFont, style);
    }

    @Override
    public Char getDefaultChar(char c, int style) {
        if (c >= '0' && c <= '9') {
            return this.getChar(c, defaultTextStyleMappings[0], style);
        }
        if (c >= 'a' && c <= 'z') {
            return this.getChar(c, defaultTextStyleMappings[2], style);
        }
        return this.getChar(c, defaultTextStyleMappings[1], style);
    }

    @Override
    public Extension getExtension(Char c, int style) {
        int fontId = c.getFontId();
        float s = DefaultTeXFont.getSizeFactor(style);
        FontInfo info = this.getFontInfo(fontId);
        int[] ext = info.getExtension(c.getChar());
        Char[] parts = new Char[ext.length];
        for (int i = 0; i < ext.length; ++i) {
            parts[i] = ext[i] == -1 ? null : new Char((char)ext[i], fontId, this.getMetrics(new CharFont((char)ext[i], fontId), s));
        }
        return new Extension(parts[0], parts[1], parts[2], parts[3]);
    }

    @Override
    public float getKern(CharFont left, CharFont right, int style) {
        if (left.fontId == right.fontId) {
            FontInfo info = this.getFontInfo(left.fontId);
            return info.getKern(left.c, right.c, this.getScaledSizeFactor(style));
        }
        return 0.0f;
    }

    @Override
    public CharFont getLigature(CharFont left, CharFont right) {
        if (left.fontId == right.fontId) {
            FontInfo info = this.getFontInfo(left.fontId);
            return info.getLigature(left.c, right.c);
        }
        return null;
    }

    private Metrics getMetrics(CharFont cf, float size) {
        FontInfo info = this.getFontInfo(cf.fontId);
        float[] m = info.getMetrics(cf.c);
        return new Metrics(m[0], m[1], m[2], m[3], size, size * TeXFormula.PIXELS_PER_POINT);
    }

    @Override
    public int getMuFontId() {
        return sMuFontId;
    }

    @Override
    public Char getNextLarger(Char c, int style) {
        FontInfo info = this.getFontInfo(c.getFontId());
        CharFont ch = info.getNextLarger(c.getChar());
        float sizeFactor = DefaultTeXFont.getSizeFactor(style);
        return new Char(ch.c, ch.fontId, this.getMetrics(ch, sizeFactor));
    }

    @Override
    public float getQuad(int style, int fontId) {
        FontInfo info = this.getFontInfo(fontId);
        return info.getQuad(this.getScaledSizeFactor(style));
    }

    @Override
    public float getSkew(CharFont cf, int style) {
        FontInfo info = this.getFontInfo(cf.fontId);
        char skew = info.getSkewChar();
        return this.getKern(cf, new CharFont(skew, cf.fontId), style);
    }

    @Override
    public float getXHeight(int style, int fontCode) {
        FontInfo info = this.getFontInfo(fontCode);
        return info.getXHeight(this.getScaledSizeFactor(style));
    }

    @Override
    public boolean hasNextLarger(Char c) {
        FontInfo info = this.getFontInfo(c.getFontId());
        return info.getNextLarger(c.getChar()) != null;
    }

    @Override
    public boolean hasSpace(int font) {
        FontInfo info = this.getFontInfo(font);
        return info.hasSpace();
    }

    @Override
    public boolean isExtensionChar(Char c) {
        FontInfo info = this.getFontInfo(c.getFontId());
        return info.getExtension(c.getChar()) != null;
    }

    @Override
    public FontInfo getFontInfo(int fontId) {
        return fontInfo[fontId];
    }

    private static float getParameter(String parameterName) {
        Float param = parameters.get(parameterName);
        return param == null ? 0.0f : param.floatValue();
    }

    private static float getSizeFactor(int style) {
        if (style < 4) {
            return 1.0f;
        }
        if (style < 6) {
            return sScriptFactor;
        }
        return sScriptScriptFactor;
    }

    private float getScaledSizeFactor(int style) {
        return DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    static {
        DefaultTeXFontParser parser = new DefaultTeXFontParser();
        parameters = parser.parseParameters();
        generalSettings = parser.parseGeneralSettings();
        textStyleMappings = parser.getParsedTextStyleMappings();
        defaultTextStyleMappings = parser.parseDefaultTextStyleMappings();
        symbolMappings = parser.parseSymbolMappings();
        fontInfo = parser.parseFontDescriptions();
        sMuFontId = generalSettings.get("mufontid").intValue();
        sScriptFactor = generalSettings.get("scriptfactor").floatValue();
        sScriptScriptFactor = generalSettings.get("scriptscriptfactor").floatValue();
        sSpaceFontId = generalSettings.get("spacefontid").intValue();
    }
}

