/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.asn1;

import java.io.IOException;
import net.jsign.bouncycastle.asn1.ASN1OutputStream;
import net.jsign.bouncycastle.asn1.ASN1Primitive;
import net.jsign.bouncycastle.asn1.ASN1String;
import net.jsign.bouncycastle.asn1.ASN1UniversalType;
import net.jsign.bouncycastle.asn1.DERNumericString;
import net.jsign.bouncycastle.asn1.DEROctetString;
import net.jsign.bouncycastle.util.Arrays;
import net.jsign.bouncycastle.util.Strings;

public abstract class ASN1NumericString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1NumericString.class, 18){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1NumericString.createPrimitive(dEROctetString.getOctets());
        }
    };
    final byte[] contents;

    ASN1NumericString(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    @Override
    public final String getString() {
        return Strings.fromByteArray(this.contents);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    final boolean encodeConstructed() {
        return false;
    }

    @Override
    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    @Override
    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 18, this.contents);
    }

    @Override
    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    @Override
    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1NumericString)) {
            return false;
        }
        ASN1NumericString aSN1NumericString = (ASN1NumericString)aSN1Primitive;
        return Arrays.areEqual(this.contents, aSN1NumericString.contents);
    }

    static ASN1NumericString createPrimitive(byte[] byArray) {
        return new DERNumericString(byArray, false);
    }
}

