/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.openssl.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.jsign.bouncycastle.asn1.pkcs.EncryptionScheme;
import net.jsign.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import net.jsign.bouncycastle.asn1.pkcs.PBEParameter;
import net.jsign.bouncycastle.asn1.pkcs.PBES2Parameters;
import net.jsign.bouncycastle.asn1.pkcs.PBKDF2Params;
import net.jsign.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.crypto.CharToByteConverter;
import net.jsign.bouncycastle.jcajce.PBKDF1KeyWithParameters;
import net.jsign.bouncycastle.jcajce.PKCS12KeyWithParameters;
import net.jsign.bouncycastle.jcajce.io.CipherInputStream;
import net.jsign.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.jsign.bouncycastle.jcajce.util.JcaJceHelper;
import net.jsign.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.jsign.bouncycastle.openssl.PEMException;
import net.jsign.bouncycastle.openssl.jcajce.PEMUtilities;
import net.jsign.bouncycastle.operator.InputDecryptor;
import net.jsign.bouncycastle.operator.InputDecryptorProvider;
import net.jsign.bouncycastle.operator.OperatorCreationException;

public class JceOpenSSLPKCS8DecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public InputDecryptorProvider build(final char[] cArray) throws OperatorCreationException {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                try {
                    Cipher cipher;
                    if (PEMUtilities.isPKCS5Scheme2(algorithmIdentifier.getAlgorithm())) {
                        PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
                        KeyDerivationFunc keyDerivationFunc = pBES2Parameters.getKeyDerivationFunc();
                        EncryptionScheme encryptionScheme = pBES2Parameters.getEncryptionScheme();
                        PBKDF2Params pBKDF2Params = (PBKDF2Params)keyDerivationFunc.getParameters();
                        int n = pBKDF2Params.getIterationCount().intValue();
                        byte[] byArray = pBKDF2Params.getSalt();
                        String string = encryptionScheme.getAlgorithm().getId();
                        SecretKey secretKey = PEMUtilities.isHmacSHA1(pBKDF2Params.getPrf()) ? PEMUtilities.generateSecretKeyForPKCS5Scheme2(JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper, string, cArray, byArray, n) : PEMUtilities.generateSecretKeyForPKCS5Scheme2(JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper, string, cArray, byArray, n, pBKDF2Params.getPrf());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(PEMUtilities.getCipherName(encryptionScheme.getAlgorithm()));
                        AlgorithmParameters algorithmParameters = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createAlgorithmParameters(string);
                        algorithmParameters.init(encryptionScheme.getParameters().toASN1Primitive().getEncoded());
                        cipher.init(2, (Key)secretKey, algorithmParameters);
                    } else if (PEMUtilities.isPKCS12(algorithmIdentifier.getAlgorithm())) {
                        PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(PEMUtilities.getCipherName(algorithmIdentifier.getAlgorithm()));
                        cipher.init(2, new PKCS12KeyWithParameters(cArray, pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue()));
                    } else if (PEMUtilities.isPKCS5Scheme1(algorithmIdentifier.getAlgorithm())) {
                        PBEParameter pBEParameter = PBEParameter.getInstance(algorithmIdentifier.getParameters());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(PEMUtilities.getCipherName(algorithmIdentifier.getAlgorithm()));
                        cipher.init(2, new PBKDF1KeyWithParameters(cArray, new CharToByteConverter(){}, pBEParameter.getSalt(), pBEParameter.getIterationCount().intValue()));
                    } else {
                        throw new PEMException("Unknown algorithm: " + algorithmIdentifier.getAlgorithm());
                    }
                    return new InputDecryptor(){

                        @Override
                        public InputStream getInputStream(InputStream inputStream) {
                            return new CipherInputStream(inputStream, cipher);
                        }
                    };
                }
                catch (IOException iOException) {
                    throw new OperatorCreationException(algorithmIdentifier.getAlgorithm() + " not available: " + iOException.getMessage(), iOException);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new OperatorCreationException(algorithmIdentifier.getAlgorithm() + " not available: " + generalSecurityException.getMessage(), generalSecurityException);
                }
            }
        };
    }
}

