/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.DelimiterFactory;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.SpaceAtom;
import com.whitemagicsoftware.tex.atoms.SymbolAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.HorizontalBox;
import com.whitemagicsoftware.tex.boxes.OverUnderBox;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.boxes.VerticalBox;
import com.whitemagicsoftware.tex.exceptions.InvalidUnitException;

public class OverUnderDelimiterAtom
extends Atom {
    private final Atom base;
    private final Atom script;
    private final SymbolAtom symbol;
    private final SpaceAtom kern;
    private final boolean over;

    public OverUnderDelimiterAtom(Atom base, Atom script, SymbolAtom s, int kernUnit, float kern, boolean over) throws InvalidUnitException {
        this.type = 7;
        this.base = base;
        this.script = script;
        this.symbol = s;
        this.kern = new SpaceAtom(kernUnit, 0.0f, kern, 0.0f);
        this.over = over;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        float max;
        Box b = this.base == null ? new StrutBox() : this.base.createBox(env);
        Box del = DelimiterFactory.create(this.symbol.getName(), env, b.getWidth());
        Box scriptBox = null;
        if (this.script != null) {
            scriptBox = this.script.createBox(this.over ? env.supStyle() : env.subStyle());
        }
        if (Math.abs((max = OverUnderDelimiterAtom.getMaxWidth(b, del, scriptBox)) - b.getWidth()) > 1.0E-7f) {
            b = new HorizontalBox(b, max, 2);
        }
        if (Math.abs(max - del.getHeight() - del.getDepth()) > 1.0E-7f) {
            del = new VerticalBox(del, max, 2);
        }
        if (scriptBox != null && Math.abs(max - scriptBox.getWidth()) > 1.0E-7f) {
            scriptBox = new HorizontalBox(scriptBox, max, 2);
        }
        return new OverUnderBox(b, del, scriptBox, this.kern.createBox(env).getHeight(), this.over);
    }

    private static float getMaxWidth(Box b, Box del, Box script) {
        float max = Math.max(b.getWidth(), del.getHeight() + del.getDepth());
        if (script != null) {
            max = Math.max(max, script.getWidth());
        }
        return max;
    }
}

