/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.CharFont;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.atoms.CharSymbolAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.CharBox;
import com.whitemagicsoftware.tex.exceptions.InvalidSymbolTypeException;
import com.whitemagicsoftware.tex.exceptions.SymbolNotFoundException;
import com.whitemagicsoftware.tex.parsers.TeXSymbolParser;
import java.util.BitSet;
import java.util.Map;

public class SymbolAtom
extends CharSymbolAtom {
    private static final BitSet validSymbolTypes = new BitSet(16);
    private static final Map<String, SymbolAtom> symbols;
    private final String name;
    private final boolean delimiter;

    public SymbolAtom(SymbolAtom symbolAtom, int type) throws InvalidSymbolTypeException {
        this(symbolAtom.name, type, symbolAtom.delimiter);
    }

    public SymbolAtom(String name, int type, boolean delimiter) throws InvalidSymbolTypeException {
        if (!validSymbolTypes.get(type)) {
            throw new InvalidSymbolTypeException("The symbol type was not valid! Use one of the symbol type constants from the class 'TeXConstants'.");
        }
        this.name = name;
        this.type = type;
        this.delimiter = delimiter;
    }

    public static SymbolAtom get(String name) throws SymbolNotFoundException {
        SymbolAtom obj = SymbolAtom.getNullable(name);
        if (obj == null) {
            throw new SymbolNotFoundException(name);
        }
        return obj;
    }

    public static SymbolAtom getNullable(String name) {
        return symbols.get(name);
    }

    public boolean isDelimiter() {
        return this.delimiter;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        return new CharBox(tf.getChar(this.name, style));
    }

    @Override
    public CharFont getCharFont(TeXFont tf) {
        return tf.getChar(this.name, 0).getCharFont();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + "', type=" + this.type + ", delimiter=" + this.delimiter + "}";
    }

    static {
        validSymbolTypes.set(0);
        validSymbolTypes.set(1);
        validSymbolTypes.set(2);
        validSymbolTypes.set(3);
        validSymbolTypes.set(4);
        validSymbolTypes.set(5);
        validSymbolTypes.set(6);
        validSymbolTypes.set(10);
        symbols = new TeXSymbolParser().readSymbols();
    }
}

