/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.graphics;

import com.whitemagicsoftware.tex.graphics.AbstractGraphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public final class SvgGraphics2D
extends AbstractGraphics2D {
    private static final int DEFAULT_SVG_BUFFER_SIZE = 65536;
    private static final String HEADER = "<svg xmlns='http://www.w3.org/2000/svg' version='1.1' ";
    private final StringBuilder mSvg;
    private final float[] mCoords = new float[6];
    private String mTransform = "";

    public SvgGraphics2D() {
        this(65536);
    }

    public SvgGraphics2D(int initialBufferSize) {
        this.mSvg = new StringBuilder(initialBufferSize).append(HEADER);
    }

    @Override
    public void initialize(int w, int h) {
        this.reset();
        this.appendDimensions(w, h);
    }

    @Override
    public void initialize(int id, int w, int h) {
        this.reset();
        this.mSvg.append("id='").append(id).append("' ");
        this.appendDimensions(w, h);
    }

    @Override
    public void draw(Shape shape) {
        this.mSvg.append("<g");
        if (!this.isIdentityTransform()) {
            this.mSvg.append(" transform='").append(this.mTransform).append('\'');
        }
        this.mSvg.append('>');
        this.appendPath((Path2D)shape);
        this.mSvg.append("</g>");
    }

    private void reset() {
        this.mSvg.setLength(HEADER.length());
    }

    private void appendDimensions(int w, int h) {
        this.mSvg.append("width='").append(w).append("px' height='").append(h).append("px'>");
    }

    private void appendPath(Path2D path) {
        this.mSvg.append("<path ");
        if (path.getWindingRule() == 0) {
            this.mSvg.append("fill-rule='evenodd' ");
        }
        this.mSvg.append("d='");
        PathIterator iterator = path.getPathIterator(null);
        while (!iterator.isDone()) {
            switch (iterator.currentSegment(this.mCoords)) {
                case 0: {
                    this.mSvg.append('M').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[0])).append(' ').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[1]));
                    break;
                }
                case 1: {
                    this.mSvg.append('L').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[0])).append(' ').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[1]));
                    break;
                }
                case 2: {
                    this.mSvg.append('Q').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[0])).append(' ').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[1])).append(' ').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[2])).append(' ').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[3]));
                    break;
                }
                case 3: {
                    this.mSvg.append('C').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[0])).append(' ').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[1])).append(' ').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[2])).append(' ').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[3])).append(' ').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[4])).append(' ').append(SvgGraphics2D.toGeometryPrecision(this.mCoords[5]));
                    break;
                }
                case 4: {
                    this.mSvg.append('Z');
                }
            }
            iterator.next();
        }
        this.mSvg.append("'/>");
    }

    @Override
    public void fill(Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shape;
            this.mSvg.append("<rect x='").append(SvgGraphics2D.toGeometryPrecision(rect.getX())).append("' y='").append(SvgGraphics2D.toGeometryPrecision(rect.getY())).append("' width='").append(SvgGraphics2D.toGeometryPrecision(rect.getWidth())).append("' height='").append(SvgGraphics2D.toGeometryPrecision(rect.getHeight()));
            if (!this.isIdentityTransform()) {
                this.mSvg.append("' transform='").append(this.mTransform);
            }
            this.mSvg.append("'/>");
        } else {
            this.draw(shape);
        }
    }

    @Override
    public void setTransform(AffineTransform at) {
        assert (at != null);
        super.setTransform(at);
        this.mTransform = this.toString(at);
    }

    @Override
    public String toString() {
        return this.mSvg.append("</svg>").toString();
    }
}

