/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.parsers;

import com.whitemagicsoftware.tex.CharFont;
import com.whitemagicsoftware.tex.FontInfo;
import com.whitemagicsoftware.tex.exceptions.ResourceParseException;
import com.whitemagicsoftware.tex.exceptions.XMLResourceParseException;
import com.whitemagicsoftware.tex.parsers.IndexedLinkedHashSet;
import com.whitemagicsoftware.tex.resources.FontResourceReader;
import com.whitemagicsoftware.tex.resources.XMLResourceReader;
import java.awt.Font;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class DefaultTeXFontParser {
    public static final int MAX_FONT_DESCRIPTIONS = 32;
    public static final String RESOURCE_NAME = "DefaultTeXFont.xml";
    public static final String STYLE_MAPPING_EL = "TextStyleMapping";
    public static final String SYMBOL_MAPPING_EL = "SymbolMapping";
    public static final String GEN_SET_EL = "GeneralSettings";
    public static final String MUFONTID_ATTR = "mufontid";
    public static final String SPACEFONTID_ATTR = "spacefontid";
    private static final IndexedLinkedHashSet<String> mResolvedFontInfo = new IndexedLinkedHashSet();
    private static Map<String, Integer> rangeTypeMappings = new HashMap<String, Integer>();
    private static Map<String, CharChildParser> charChildParsers;
    private Map<String, CharFont[]> parsedTextStyles;
    private Element root = new XMLResourceReader("DefaultTeXFont.xml").read();

    private static int parseFontIdElement(Element element) {
        return DefaultTeXFontParser.parseFontIdElement("fontId", element);
    }

    private static int resolveFontId(String fontId) {
        return mResolvedFontInfo.addIndex(fontId);
    }

    private static int parseFontIdElement(String attribute, Element element) {
        String fontId = DefaultTeXFontParser.parseStringElement(attribute, element);
        return DefaultTeXFontParser.resolveFontId(fontId);
    }

    public DefaultTeXFontParser() throws ResourceParseException {
        this.parsedTextStyles = this.parseStyleMappings();
    }

    public FontInfo[] parseFontDescriptions() throws ResourceParseException {
        FontInfo[] res = new FontInfo[32];
        Element fontDescriptions = this.root.getChild("FontDescriptions");
        if (fontDescriptions != null) {
            for (Element font : fontDescriptions.getChildren("Font")) {
                String name = DefaultTeXFontParser.parseStringElement("name", font);
                int id = DefaultTeXFontParser.parseFontIdElement("id", font);
                float space = DefaultTeXFontParser.parseFloatElement("space", font);
                float xHeight = DefaultTeXFontParser.parseFloatElement("xHeight", font);
                float quad = DefaultTeXFontParser.parseFloatElement("quad", font);
                int skewChar = DefaultTeXFontParser.parseOptionalInt("skewChar", font, -1);
                Font f = new FontResourceReader(name).read();
                FontInfo info = new FontInfo(id, f, xHeight, space, quad);
                if (skewChar != -1) {
                    info.setSkewChar((char)skewChar);
                }
                for (Element element : font.getChildren("Char")) {
                    DefaultTeXFontParser.processCharElement(element, info);
                }
                res[id] = info;
            }
        }
        return res;
    }

    private static void processCharElement(Element charElement, FontInfo info) throws ResourceParseException {
        char ch = (char)DefaultTeXFontParser.parseIntElement("code", charElement);
        float[] metrics = new float[]{DefaultTeXFontParser.parseOptionalFloat("width", charElement, 0.0f), DefaultTeXFontParser.parseOptionalFloat("height", charElement, 0.0f), DefaultTeXFontParser.parseOptionalFloat("depth", charElement, 0.0f), DefaultTeXFontParser.parseOptionalFloat("italic", charElement, 0.0f)};
        info.setMetrics(ch, metrics);
        for (Element el : charElement.getChildren()) {
            String elName = el.getName();
            CharChildParser parser = charChildParsers.get(elName);
            if (parser == null) {
                String msg = String.format("%s: a <Char>-element has unknown child element '%s'", RESOURCE_NAME, elName);
                throw new XMLResourceParseException(msg);
            }
            parser.parse(el, ch, info);
        }
    }

    public Map<String, CharFont> parseSymbolMappings() throws ResourceParseException {
        Element symbolMappings = this.root.getChild("SymbolMappings");
        if (symbolMappings == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, "SymbolMappings");
        }
        HashMap<String, CharFont> res = new HashMap<String, CharFont>();
        for (Element mapping : symbolMappings.getChildren(SYMBOL_MAPPING_EL)) {
            String symbolName = DefaultTeXFontParser.parseStringElement("name", mapping);
            int ch = DefaultTeXFontParser.parseIntElement("ch", mapping);
            int fontId = DefaultTeXFontParser.parseFontIdElement(mapping);
            res.put(symbolName, new CharFont((char)ch, fontId));
        }
        if (res.get("sqrt") == null) {
            throw new XMLResourceParseException("DefaultTeXFont.xml: the required mapping <SymbolMap name=\"sqrt\" ... /> is not found!");
        }
        return res;
    }

    public String[] parseDefaultTextStyleMappings() throws ResourceParseException {
        Element defaultTextStyleMappings = this.root.getChild("DefaultTextStyleMapping");
        if (defaultTextStyleMappings == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, "DefaultTextStyleMapping");
        }
        String[] res = new String[3];
        for (Element mapping : defaultTextStyleMappings.getChildren("MapStyle")) {
            String code = DefaultTeXFontParser.parseStringElement("code", mapping);
            Integer codeMapping = rangeTypeMappings.get(code);
            if (codeMapping == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, "MapStyle", "code", "contains an unknown \"range name\" '" + code + "'");
            }
            String textStyleName = DefaultTeXFontParser.parseStringElement("textStyle", mapping);
            CharFont[] styleMapping = this.parsedTextStyles.get(textStyleName);
            if (styleMapping == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, "MapStyle", "textStyle", "contains an unknown text style '" + textStyleName + "'");
            }
            CharFont[] charFonts = this.parsedTextStyles.get(textStyleName);
            if (charFonts[codeMapping] == null) {
                throw new XMLResourceParseException("DefaultTeXFont.xml: the default text style mapping '" + textStyleName + "' for the range '" + code + "' contains no mapping for that range!");
            }
            res[codeMapping.intValue()] = textStyleName;
        }
        return res;
    }

    public Map<String, Float> parseParameters() throws ResourceParseException {
        Element parameters = this.root.getChild("Parameters");
        if (parameters == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, "Parameters");
        }
        HashMap<String, Float> res = new HashMap<String, Float>();
        for (Attribute attr : parameters.getAttributes()) {
            String name = attr.getName();
            res.put(name, Float.valueOf(DefaultTeXFontParser.parseFloatElement(name, parameters)));
        }
        return res;
    }

    public Map<String, Number> parseGeneralSettings() throws ResourceParseException {
        Element generalSettings = this.root.getChild(GEN_SET_EL);
        if (generalSettings == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, GEN_SET_EL);
        }
        HashMap<String, Number> result = new HashMap<String, Number>();
        result.put(MUFONTID_ATTR, DefaultTeXFontParser.parseFontIdElement(MUFONTID_ATTR, generalSettings));
        result.put(SPACEFONTID_ATTR, DefaultTeXFontParser.parseFontIdElement(SPACEFONTID_ATTR, generalSettings));
        result.put("scriptfactor", Float.valueOf(DefaultTeXFontParser.parseFloatElement("scriptfactor", generalSettings)));
        result.put("scriptscriptfactor", Float.valueOf(DefaultTeXFontParser.parseFloatElement("scriptscriptfactor", generalSettings)));
        return result;
    }

    public Map<String, CharFont[]> getParsedTextStyleMappings() {
        return this.parsedTextStyles;
    }

    private Map<String, CharFont[]> parseStyleMappings() throws ResourceParseException {
        Element textStyleMappings = this.root.getChild("TextStyleMappings");
        if (textStyleMappings == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, "TextStyleMappings");
        }
        HashMap<String, CharFont[]> res = new HashMap<String, CharFont[]>();
        for (Element mapping : textStyleMappings.getChildren(STYLE_MAPPING_EL)) {
            String textStyleName = DefaultTeXFontParser.parseStringElement("name", mapping);
            List<Element> mapRangeList = mapping.getChildren("MapRange");
            CharFont[] charFonts = new CharFont[3];
            for (Element mapRange : mapRangeList) {
                int fontId = DefaultTeXFontParser.parseFontIdElement(mapRange);
                int ch = DefaultTeXFontParser.parseIntElement("start", mapRange);
                String code = DefaultTeXFontParser.parseStringElement("code", mapRange);
                Integer codeMapping = rangeTypeMappings.get(code);
                if (codeMapping == null) {
                    throw new XMLResourceParseException(RESOURCE_NAME, "MapRange", "code", "contains an unknown \"range name\" '" + code + "'");
                }
                charFonts[codeMapping.intValue()] = new CharFont((char)ch, fontId);
            }
            res.put(textStyleName, charFonts);
        }
        return res;
    }

    public static float parseFloatElement(String attrName, Element element) throws ResourceParseException {
        String attrValue = DefaultTeXFontParser.parseStringElement(attrName, element);
        float res = 0.0f;
        try {
            res = (float)Double.parseDouble(attrValue);
        }
        catch (NumberFormatException e) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getName(), attrName, "has an invalid real value!");
        }
        return res;
    }

    public static int parseIntElement(String attrName, Element element) throws ResourceParseException {
        String attrValue = DefaultTeXFontParser.parseStringElement(attrName, element);
        int res = 0;
        try {
            res = Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getName(), attrName, "must be an integer value, not: '" + attrValue + "'");
        }
        return res;
    }

    public static int parseOptionalInt(String attrName, Element element, int defaultValue) throws ResourceParseException {
        String attrValue = element.getAttributeValue(attrName);
        if (attrValue == null) {
            return defaultValue;
        }
        int res = 0;
        try {
            res = Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getName(), attrName, "has an invalid integer value!");
        }
        return res;
    }

    public static float parseOptionalFloat(String attrName, Element element, float defaultValue) throws ResourceParseException {
        String attrValue = element.getAttributeValue(attrName);
        if (attrValue == null) {
            return defaultValue;
        }
        float res = 0.0f;
        try {
            res = (float)Double.parseDouble(attrValue);
        }
        catch (NumberFormatException e) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getName(), attrName, "has an invalid float value!");
        }
        return res;
    }

    private static String parseStringElement(String attrName, Element element) throws ResourceParseException {
        String attrValue = element.getAttributeValue(attrName);
        if (attrValue == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getName(), attrName, null);
        }
        return attrValue;
    }

    static {
        rangeTypeMappings.put("numbers", 0);
        rangeTypeMappings.put("capitals", 1);
        rangeTypeMappings.put("small", 2);
        rangeTypeMappings.put("unicode", 3);
        charChildParsers = new HashMap<String, CharChildParser>();
        charChildParsers.put("Kern", new KernParser());
        charChildParsers.put("Lig", new LigParser());
        charChildParsers.put("NextLarger", new NextLargerParser());
        charChildParsers.put("Extension", new ExtensionParser());
    }

    private static interface CharChildParser {
        public void parse(Element var1, char var2, FontInfo var3) throws XMLResourceParseException;
    }

    private static class KernParser
    implements CharChildParser {
        KernParser() {
        }

        @Override
        public void parse(Element el, char ch, FontInfo info) throws ResourceParseException {
            int code = DefaultTeXFontParser.parseIntElement("code", el);
            float kernAmount = DefaultTeXFontParser.parseFloatElement("val", el);
            info.addKern(ch, (char)code, kernAmount);
        }
    }

    private static class LigParser
    implements CharChildParser {
        LigParser() {
        }

        @Override
        public void parse(Element el, char ch, FontInfo info) throws ResourceParseException {
            int code = DefaultTeXFontParser.parseIntElement("code", el);
            int ligCode = DefaultTeXFontParser.parseIntElement("ligCode", el);
            info.addLigature(ch, (char)code, (char)ligCode);
        }
    }

    private static class NextLargerParser
    implements CharChildParser {
        NextLargerParser() {
        }

        @Override
        public void parse(Element el, char ch, FontInfo info) throws ResourceParseException {
            int fontId = DefaultTeXFontParser.parseFontIdElement(el);
            int code = DefaultTeXFontParser.parseIntElement("code", el);
            info.setNextLarger(ch, (char)code, fontId);
        }
    }

    private static class ExtensionParser
    implements CharChildParser {
        ExtensionParser() {
        }

        @Override
        public void parse(Element el, char ch, FontInfo info) throws ResourceParseException {
            int[] extensionChars = new int[4];
            extensionChars[2] = DefaultTeXFontParser.parseIntElement("rep", el);
            extensionChars[0] = DefaultTeXFontParser.parseOptionalInt("top", el, -1);
            extensionChars[1] = DefaultTeXFontParser.parseOptionalInt("mid", el, -1);
            extensionChars[3] = DefaultTeXFontParser.parseOptionalInt("bot", el, -1);
            info.setExtension(ch, extensionChars);
        }
    }
}

