/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.parser;

import com.whitemagicsoftware.keenquotes.parser.Stem;
import com.whitemagicsoftware.keenquotes.parser.Token;
import com.whitemagicsoftware.keenquotes.parser.TokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

class Tree<T extends Token>
implements Stem {
    private final Tree<T> mParent;
    private final Collection<Stem> mStems = new LinkedHashSet<Stem>(128);
    private final T mOpening;
    private T mClosing = Token.NONE;

    public Tree() {
        this.mParent = null;
        this.mOpening = Token.NONE;
    }

    private Tree(Tree<T> parent, T opening) {
        assert (parent != null);
        assert (opening != null);
        assert (opening != Token.NONE);
        this.mParent = parent;
        this.mOpening = opening;
    }

    public boolean hasOpeningSingleQuote() {
        return this.isOpening(TokenType.QUOTE_OPENING_SINGLE);
    }

    public boolean hasOpeningDoubleQuote() {
        return this.isOpening(TokenType.QUOTE_OPENING_DOUBLE);
    }

    private boolean isOpening(TokenType tokenType) {
        return ((Token)this.mOpening).isType(tokenType);
    }

    public boolean hasClosingSingleQuote() {
        return ((Token)this.mClosing).isType(TokenType.QUOTE_CLOSING_SINGLE);
    }

    public boolean isBalanced() {
        return ((Token)this.mOpening).isType(TokenType.QUOTE_OPENING_DOUBLE) && ((Token)this.mClosing).isType(TokenType.QUOTE_CLOSING_DOUBLE) || this.hasOpeningSingleQuote() && this.hasClosingSingleQuote();
    }

    public int count(TokenType tokenType) {
        AtomicInteger count = new AtomicInteger();
        this.iterateTokens(token -> {
            if (token.isType(tokenType)) {
                count.incrementAndGet();
            }
        });
        return count.get();
    }

    public void iterateTokens(Consumer<Token> consumer) {
        if (!((Token)this.mOpening).isType(TokenType.NONE)) {
            consumer.accept((Token)this.mOpening);
        }
        for (Stem stem : this.mStems) {
            if (!(stem instanceof Token)) continue;
            Token token = (Token)stem;
            consumer.accept(token);
        }
        if (!((Token)this.mClosing).isType(TokenType.NONE)) {
            consumer.accept((Token)this.mClosing);
        }
    }

    public void visit(Consumer<Tree<T>> consumer) {
        LinkedList<Tree<T>> queue = new LinkedList<Tree<T>>();
        queue.add(this);
        while (!queue.isEmpty()) {
            Tree current = (Tree)queue.poll();
            consumer.accept(current);
            queue.addAll(current.subtrees());
        }
    }

    Tree<T> opening(T opening) {
        assert (opening != null);
        return this.add(new Tree<T>(this, opening));
    }

    Tree<T> closing(T closing) {
        assert (closing != Token.NONE);
        assert (((Token)this.mOpening).isBefore((Token)closing));
        this.mClosing = closing;
        return this.mParent == null ? this : this.mParent;
    }

    <S extends Stem> S add(S stem) {
        assert (stem != null);
        this.mStems.add(stem);
        return stem;
    }

    Tree<T> root() {
        Tree<T> ancestor = this;
        while (ancestor.parent() != null) {
            ancestor = ancestor.parent();
        }
        return ancestor;
    }

    void replaceAll(TokenType oldToken, TokenType newToken) {
        for (Stem stem : this.mStems) {
            Token token;
            if (!(stem instanceof Token) || !(token = (Token)stem).isType(oldToken)) continue;
            token.setTokenType(newToken);
        }
    }

    private Tree<T> parent() {
        return this.mParent;
    }

    private List<Tree<T>> subtrees() {
        ArrayList<Tree<T>> result = new ArrayList<Tree<T>>();
        for (Stem stem : this.mStems) {
            if (!(stem instanceof Tree)) continue;
            Tree tree = (Tree)stem;
            result.add(tree);
        }
        return result;
    }

    @Override
    public String toXml() {
        StringBuilder sb = new StringBuilder(128);
        String name = this.parent() == null ? "root" : "tree";
        sb.append('<');
        sb.append(name);
        sb.append('>');
        if (!((Token)this.mOpening).isType(TokenType.NONE)) {
            sb.append(((Token)this.mOpening).toXml());
        }
        this.mStems.forEach(stem -> sb.append(stem.toXml()));
        if (!((Token)this.mClosing).isType(TokenType.NONE)) {
            sb.append(((Token)this.mClosing).toXml());
        }
        sb.append("</");
        sb.append(name);
        sb.append('>');
        return sb.toString();
    }
}

