/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.Closeable;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.CloseableThreadLocal;

public abstract class Analyzer
implements Closeable {
    private final ReuseStrategy reuseStrategy;
    CloseableThreadLocal<Object> storedValue = new CloseableThreadLocal();
    public static final ReuseStrategy GLOBAL_REUSE_STRATEGY = new ReuseStrategy(){

        @Override
        public TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            return (TokenStreamComponents)this.getStoredValue(analyzer);
        }

        @Override
        public void setReusableComponents(Analyzer analyzer, String fieldName, TokenStreamComponents components) {
            this.setStoredValue(analyzer, components);
        }
    };
    public static final ReuseStrategy PER_FIELD_REUSE_STRATEGY = new ReuseStrategy(){

        @Override
        public TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            Map componentsPerField = (Map)this.getStoredValue(analyzer);
            return componentsPerField != null ? (TokenStreamComponents)componentsPerField.get(fieldName) : null;
        }

        @Override
        public void setReusableComponents(Analyzer analyzer, String fieldName, TokenStreamComponents components) {
            HashMap<String, TokenStreamComponents> componentsPerField = (HashMap<String, TokenStreamComponents>)this.getStoredValue(analyzer);
            if (componentsPerField == null) {
                componentsPerField = new HashMap<String, TokenStreamComponents>();
                this.setStoredValue(analyzer, componentsPerField);
            }
            componentsPerField.put(fieldName, components);
        }
    };

    protected Analyzer() {
        this(GLOBAL_REUSE_STRATEGY);
    }

    protected Analyzer(ReuseStrategy reuseStrategy) {
        this.reuseStrategy = reuseStrategy;
    }

    protected abstract TokenStreamComponents createComponents(String var1);

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStreamComponents components = this.reuseStrategy.getReusableComponents(this, fieldName);
        Reader r = this.initReader(fieldName, reader);
        if (components == null) {
            components = this.createComponents(fieldName);
            this.reuseStrategy.setReusableComponents(this, fieldName, components);
        }
        components.setReader(r);
        return components.getTokenStream();
    }

    protected Reader initReader(String fieldName, Reader reader) {
        return reader;
    }

    @Override
    public void close() {
        if (this.storedValue != null) {
            this.storedValue.close();
            this.storedValue = null;
        }
    }

    public static abstract class ReuseStrategy {
        protected ReuseStrategy() {
        }

        public abstract TokenStreamComponents getReusableComponents(Analyzer var1, String var2);

        public abstract void setReusableComponents(Analyzer var1, String var2, TokenStreamComponents var3);

        protected final Object getStoredValue(Analyzer analyzer) {
            if (analyzer.storedValue == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            return analyzer.storedValue.get();
        }

        protected final void setStoredValue(Analyzer analyzer, Object storedValue) {
            if (analyzer.storedValue == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            analyzer.storedValue.set(storedValue);
        }
    }

    public static final class TokenStreamComponents {
        protected final Consumer<Reader> source;
        protected final TokenStream sink;

        public TokenStreamComponents(Consumer<Reader> source, TokenStream result) {
            this.source = source;
            this.sink = result;
        }

        public TokenStreamComponents(Tokenizer tokenizer, TokenStream result) {
            this(tokenizer::setReader, result);
        }

        private void setReader(Reader reader) {
            this.source.accept(reader);
        }

        public TokenStream getTokenStream() {
            return this.sink;
        }
    }
}

