/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.cjk.CJKWidthCharFilter;
import org.apache.lucene.analysis.ja.JapaneseBaseFormFilter;
import org.apache.lucene.analysis.ja.JapaneseKatakanaStemFilter;
import org.apache.lucene.analysis.ja.JapanesePartOfSpeechStopFilter;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.util.IOUtils;

public class JapaneseAnalyzer
extends StopwordAnalyzerBase {
    private final JapaneseTokenizer.Mode mode;
    private final Set<String> stoptags;
    private final UserDictionary userDict;

    public JapaneseAnalyzer() {
        this(null, JapaneseTokenizer.DEFAULT_MODE, DefaultSetHolder.DEFAULT_STOP_SET, DefaultSetHolder.DEFAULT_STOP_TAGS);
    }

    public JapaneseAnalyzer(UserDictionary userDict, JapaneseTokenizer.Mode mode, CharArraySet stopwords, Set<String> stoptags) {
        super(stopwords);
        this.userDict = userDict;
        this.mode = mode;
        this.stoptags = stoptags;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(this.userDict, true, true, this.mode);
        TokenFilter stream = new JapaneseBaseFormFilter(tokenizer);
        stream = new JapanesePartOfSpeechStopFilter(stream, this.stoptags);
        stream = new StopFilter(stream, this.stopwords);
        stream = new JapaneseKatakanaStemFilter(stream);
        stream = new LowerCaseFilter(stream);
        return new Analyzer.TokenStreamComponents(tokenizer, (TokenStream)stream);
    }

    @Override
    protected Reader initReader(String fieldName, Reader reader) {
        return new CJKWidthCharFilter(reader);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;
        static final Set<String> DEFAULT_STOP_TAGS;

        static {
            try {
                DEFAULT_STOP_SET = CharArraySet.unmodifiableSet(WordlistLoader.getWordSet(IOUtils.getDecodingReader(IOUtils.requireResourceNonNull(JapaneseAnalyzer.class.getResourceAsStream("stopwords.txt"), "stopwords.txt"), StandardCharsets.UTF_8), "#", new CharArraySet(16, true)));
                CharArraySet tagset = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(JapaneseAnalyzer.class.getResourceAsStream("stoptags.txt"), "stoptags.txt"), "#");
                DEFAULT_STOP_TAGS = tagset.stream().map(ca -> new String((char[])ca)).collect(Collectors.toUnmodifiableSet());
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword or stoptag set", ex);
            }
        }
    }
}

