/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOUtils;

public final class CharacterDefinition {
    public static final int CLASS_COUNT = CharacterClass.values().length;
    private final byte[] characterCategoryMap = new byte[65536];
    private final boolean[] invokeMap = new boolean[CLASS_COUNT];
    private final boolean[] groupMap = new boolean[CLASS_COUNT];
    public static final byte NGRAM = (byte)CharacterClass.NGRAM.ordinal();
    public static final byte DEFAULT = (byte)CharacterClass.DEFAULT.ordinal();
    public static final byte SPACE = (byte)CharacterClass.SPACE.ordinal();
    public static final byte SYMBOL = (byte)CharacterClass.SYMBOL.ordinal();
    public static final byte NUMERIC = (byte)CharacterClass.NUMERIC.ordinal();
    public static final byte ALPHA = (byte)CharacterClass.ALPHA.ordinal();
    public static final byte CYRILLIC = (byte)CharacterClass.CYRILLIC.ordinal();
    public static final byte GREEK = (byte)CharacterClass.GREEK.ordinal();
    public static final byte HIRAGANA = (byte)CharacterClass.HIRAGANA.ordinal();
    public static final byte KATAKANA = (byte)CharacterClass.KATAKANA.ordinal();
    public static final byte KANJI = (byte)CharacterClass.KANJI.ordinal();
    public static final byte KANJINUMERIC = (byte)CharacterClass.KANJINUMERIC.ordinal();

    private CharacterDefinition() throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(CharacterDefinition.getClassResource());){
            InputStreamDataInput in = new InputStreamDataInput(is);
            CodecUtil.checkHeader(in, "kuromoji_cd", 1, 1);
            ((DataInput)in).readBytes(this.characterCategoryMap, 0, this.characterCategoryMap.length);
            for (int i = 0; i < CLASS_COUNT; ++i) {
                byte b = ((DataInput)in).readByte();
                this.invokeMap[i] = (b & 1) != 0;
                this.groupMap[i] = (b & 2) != 0;
            }
        }
    }

    private static InputStream getClassResource() throws IOException {
        String resourcePath = CharacterDefinition.class.getSimpleName() + ".dat";
        return IOUtils.requireResourceNonNull(CharacterDefinition.class.getResourceAsStream(resourcePath), resourcePath);
    }

    public byte getCharacterClass(char c) {
        return this.characterCategoryMap[c];
    }

    public boolean isInvoke(char c) {
        return this.invokeMap[this.characterCategoryMap[c]];
    }

    public boolean isGroup(char c) {
        return this.groupMap[this.characterCategoryMap[c]];
    }

    public boolean isKanji(char c) {
        byte characterClass = this.characterCategoryMap[c];
        return characterClass == KANJI || characterClass == KANJINUMERIC;
    }

    public static CharacterDefinition getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        static final CharacterDefinition INSTANCE;

        static {
            try {
                INSTANCE = new CharacterDefinition();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load CharacterDefinition.", ioe);
            }
        }
    }

    private static final class CharacterClass
    extends Enum<CharacterClass> {
        public static final /* enum */ CharacterClass NGRAM = new CharacterClass();
        public static final /* enum */ CharacterClass DEFAULT = new CharacterClass();
        public static final /* enum */ CharacterClass SPACE = new CharacterClass();
        public static final /* enum */ CharacterClass SYMBOL = new CharacterClass();
        public static final /* enum */ CharacterClass NUMERIC = new CharacterClass();
        public static final /* enum */ CharacterClass ALPHA = new CharacterClass();
        public static final /* enum */ CharacterClass CYRILLIC = new CharacterClass();
        public static final /* enum */ CharacterClass GREEK = new CharacterClass();
        public static final /* enum */ CharacterClass HIRAGANA = new CharacterClass();
        public static final /* enum */ CharacterClass KATAKANA = new CharacterClass();
        public static final /* enum */ CharacterClass KANJI = new CharacterClass();
        public static final /* enum */ CharacterClass KANJINUMERIC = new CharacterClass();
        private static final /* synthetic */ CharacterClass[] $VALUES;

        public static CharacterClass[] values() {
            return (CharacterClass[])$VALUES.clone();
        }

        static {
            $VALUES = new CharacterClass[]{NGRAM, DEFAULT, SPACE, SYMBOL, NUMERIC, ALPHA, CYRILLIC, GREEK, HIRAGANA, KATAKANA, KANJI, KANJINUMERIC};
        }
    }
}

