/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.util.Map;
import org.apache.lucene.analysis.ko.KoreanTokenizer;
import org.apache.lucene.analysis.ko.dict.ConnectionCosts;
import org.apache.lucene.analysis.ko.dict.Dictionary;

public class GraphvizFormatter {
    private final ConnectionCosts costs;
    private final Map<String, String> bestPathMap;
    private final StringBuilder sb;

    void onBacktrace(KoreanTokenizer tok, KoreanTokenizer.WrappedPositionArray positions, int lastBackTracePos, KoreanTokenizer.Position endPosData, int fromIDX, char[] fragment, boolean isEnd) {
        this.setBestPathMap(positions, lastBackTracePos, endPosData, fromIDX);
        this.sb.append(this.formatNodes(tok, positions, lastBackTracePos, endPosData, fragment));
        if (isEnd) {
            this.sb.append("  fini [style=invis]\n");
            this.sb.append("  ");
            this.sb.append(this.getNodeID(endPosData.pos, fromIDX));
            this.sb.append(" -> fini [label=\"EOS\"]");
        }
    }

    private void setBestPathMap(KoreanTokenizer.WrappedPositionArray positions, int startPos, KoreanTokenizer.Position endPosData, int fromIDX) {
        this.bestPathMap.clear();
        int pos = endPosData.pos;
        int bestIDX = fromIDX;
        while (pos > startPos) {
            KoreanTokenizer.Position posData = positions.get(pos);
            int backPos = posData.backPos[bestIDX];
            int backIDX = posData.backIndex[bestIDX];
            String toNodeID = this.getNodeID(pos, bestIDX);
            String fromNodeID = this.getNodeID(backPos, backIDX);
            assert (!this.bestPathMap.containsKey(fromNodeID));
            assert (!this.bestPathMap.containsValue(toNodeID));
            this.bestPathMap.put(fromNodeID, toNodeID);
            pos = backPos;
            bestIDX = backIDX;
        }
    }

    private String formatNodes(KoreanTokenizer tok, KoreanTokenizer.WrappedPositionArray positions, int startPos, KoreanTokenizer.Position endPosData, char[] fragment) {
        int idx;
        KoreanTokenizer.Position posData;
        int pos;
        StringBuilder sb = new StringBuilder();
        for (pos = startPos + 1; pos <= endPosData.pos; ++pos) {
            posData = positions.get(pos);
            for (idx = 0; idx < posData.count; ++idx) {
                sb.append("  ");
                sb.append(this.getNodeID(pos, idx));
                sb.append(" [label=\"");
                sb.append(pos);
                sb.append(": ");
                sb.append(posData.lastRightID[idx]);
                sb.append("\"]\n");
            }
        }
        for (pos = endPosData.pos; pos > startPos; --pos) {
            posData = positions.get(pos);
            for (idx = 0; idx < posData.count; ++idx) {
                KoreanTokenizer.Position backPosData = positions.get(posData.backPos[idx]);
                String toNodeID = this.getNodeID(pos, idx);
                String fromNodeID = this.getNodeID(posData.backPos[idx], posData.backIndex[idx]);
                sb.append("  ");
                sb.append(fromNodeID);
                sb.append(" -> ");
                sb.append(toNodeID);
                String attrs = toNodeID.equals(this.bestPathMap.get(fromNodeID)) ? " color=\"#40e050\" fontcolor=\"#40a050\" penwidth=3 fontsize=20" : "";
                Dictionary dict = tok.getDict(posData.backType[idx]);
                int wordCost = dict.getWordCost(posData.backID[idx]);
                int bgCost = this.costs.get(backPosData.lastRightID[posData.backIndex[idx]], dict.getLeftId(posData.backID[idx]));
                String surfaceForm = new String(fragment, posData.backPos[idx] - startPos, pos - posData.backPos[idx]);
                sb.append(" [label=\"");
                sb.append(surfaceForm);
                sb.append(' ');
                sb.append(wordCost);
                if (bgCost >= 0) {
                    sb.append('+');
                }
                sb.append(bgCost);
                sb.append("\"");
                sb.append(attrs);
                sb.append("]\n");
            }
        }
        return sb.toString();
    }

    private String getNodeID(int pos, int idx) {
        return pos + "." + idx;
    }
}

