/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.ko.dict.BinaryDictionary;
import org.apache.lucene.analysis.ko.dict.TokenInfoFST;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOSupplier;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;

public final class TokenInfoDictionary
extends BinaryDictionary {
    private final TokenInfoFST fst;

    private TokenInfoDictionary() throws IOException {
        this(() -> TokenInfoDictionary.getClassResource("$targetMap.dat"), () -> TokenInfoDictionary.getClassResource("$posDict.dat"), () -> TokenInfoDictionary.getClassResource("$buffer.dat"), () -> TokenInfoDictionary.getClassResource("$fst.dat"));
    }

    private TokenInfoDictionary(IOSupplier<InputStream> targetMapResource, IOSupplier<InputStream> posResource, IOSupplier<InputStream> dictResource, IOSupplier<InputStream> fstResource) throws IOException {
        super(targetMapResource, posResource, dictResource);
        FST<Long> fst;
        try (BufferedInputStream is = new BufferedInputStream(fstResource.get());){
            InputStreamDataInput in = new InputStreamDataInput(is);
            fst = new FST<Long>(in, in, PositiveIntOutputs.getSingleton());
        }
        this.fst = new TokenInfoFST(fst);
    }

    private static InputStream getClassResource(String suffix) throws IOException {
        String resourcePath = TokenInfoDictionary.class.getSimpleName() + suffix;
        return IOUtils.requireResourceNonNull(TokenInfoDictionary.class.getResourceAsStream(resourcePath), resourcePath);
    }

    public TokenInfoFST getFST() {
        return this.fst;
    }

    public static TokenInfoDictionary getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        static final TokenInfoDictionary INSTANCE;

        static {
            try {
                INSTANCE = new TokenInfoDictionary();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load TokenInfoDictionary.", ioe);
            }
        }
    }
}

