/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.ko.dict.BinaryDictionary;
import org.apache.lucene.analysis.ko.dict.CharacterDefinition;
import org.apache.lucene.analysis.ko.dict.Dictionary;
import org.apache.lucene.util.IOUtils;

public final class UnknownDictionary
extends BinaryDictionary {
    private final CharacterDefinition characterDefinition = CharacterDefinition.getInstance();

    private UnknownDictionary() throws IOException {
        super(() -> UnknownDictionary.getClassResource("$targetMap.dat"), () -> UnknownDictionary.getClassResource("$posDict.dat"), () -> UnknownDictionary.getClassResource("$buffer.dat"));
    }

    private static InputStream getClassResource(String suffix) throws IOException {
        String resourcePath = UnknownDictionary.class.getSimpleName() + suffix;
        return IOUtils.requireResourceNonNull(UnknownDictionary.class.getResourceAsStream(resourcePath), resourcePath);
    }

    public CharacterDefinition getCharacterDefinition() {
        return this.characterDefinition;
    }

    public static UnknownDictionary getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public Dictionary.Morpheme[] getMorphemes(int wordId, char[] surfaceForm, int off, int len) {
        return null;
    }

    private static class SingletonHolder {
        static final UnknownDictionary INSTANCE;

        static {
            try {
                INSTANCE = new UnknownDictionary();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load UnknownDictionary.", ioe);
            }
        }
    }
}

