/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.Dictionary;
import org.apache.lucene.analysis.ko.dict.TokenInfoFST;

public final class UserDictionary
implements Dictionary {
    private final TokenInfoFST fst;
    private final int[][] segmentations;
    private final short[] rightIds;

    public TokenInfoFST getFST() {
        return this.fst;
    }

    @Override
    public int getLeftId(int wordId) {
        return 1781;
    }

    @Override
    public int getRightId(int wordId) {
        return this.rightIds[wordId];
    }

    @Override
    public int getWordCost(int wordId) {
        return -100000;
    }

    @Override
    public POS.Type getPOSType(int wordId) {
        if (this.segmentations[wordId] == null) {
            return POS.Type.MORPHEME;
        }
        return POS.Type.COMPOUND;
    }

    @Override
    public POS.Tag getLeftPOS(int wordId) {
        return POS.Tag.NNG;
    }

    @Override
    public Dictionary.Morpheme[] getMorphemes(int wordId, char[] surfaceForm, int off, int len) {
        int[] segs = this.segmentations[wordId];
        if (segs == null) {
            return null;
        }
        int offset = 0;
        Dictionary.Morpheme[] morphemes = new Dictionary.Morpheme[segs.length];
        for (int i = 0; i < segs.length; ++i) {
            morphemes[i] = new Dictionary.Morpheme(POS.Tag.NNG, new String(surfaceForm, off + offset, segs[i]));
            offset += segs[i];
        }
        return morphemes;
    }
}

