/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public final class StandardAnalyzer
extends StopwordAnalyzerBase {
    private int maxTokenLength = 255;

    public StandardAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public StandardAnalyzer() {
        this(CharArraySet.EMPTY_SET);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer src = new StandardTokenizer();
        src.setMaxTokenLength(this.maxTokenLength);
        TokenFilter tok = new LowerCaseFilter(src);
        tok = new StopFilter(tok, this.stopwords);
        return new Analyzer.TokenStreamComponents(r -> {
            src.setMaxTokenLength(this.maxTokenLength);
            src.setReader((Reader)r);
        }, (TokenStream)tok);
    }
}

