/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.Constants;
import org.apache.lucene.util.RamUsageEstimator;

public final class ArrayUtil {
    public static final int MAX_ARRAY_LENGTH = Integer.MAX_VALUE - RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;

    private ArrayUtil() {
    }

    public static int oversize(int minTargetSize, int bytesPerElement) {
        int newSize;
        if (minTargetSize < 0) {
            throw new IllegalArgumentException("invalid array size " + minTargetSize);
        }
        if (minTargetSize == 0) {
            return 0;
        }
        if (minTargetSize > MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("requested array size " + minTargetSize + " exceeds maximum array in java (" + MAX_ARRAY_LENGTH + ")");
        }
        int extra = minTargetSize >> 3;
        if (extra < 3) {
            extra = 3;
        }
        if ((newSize = minTargetSize + extra) + 7 < 0 || newSize + 7 > MAX_ARRAY_LENGTH) {
            return MAX_ARRAY_LENGTH;
        }
        if (Constants.JRE_IS_64BIT) {
            switch (bytesPerElement) {
                case 4: {
                    return newSize + 1 & 0x7FFFFFFE;
                }
                case 2: {
                    return newSize + 3 & 0x7FFFFFFC;
                }
                case 1: {
                    return newSize + 7 & 0x7FFFFFF8;
                }
            }
            return newSize;
        }
        switch (bytesPerElement) {
            case 1: {
                return (newSize + 3 & 0x7FFFFFF8) + 4;
            }
            case 2: {
                return (newSize + 1 & 0x7FFFFFFC) + 2;
            }
            case 4: {
                return (newSize & 0x7FFFFFFE) + 1;
            }
        }
        return newSize;
    }

    public static int[] growExact(int[] array, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static int[] grow(int[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 4));
        }
        return array;
    }

    public static int[] grow(int[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static byte[] growExact(byte[] array, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static byte[] grow(byte[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 1));
        }
        return array;
    }

    public static int hashCode(char[] array, int start, int end) {
        int code = 0;
        for (int i = end - 1; i >= start; --i) {
            code = code * 31 + array[i];
        }
        return code;
    }
}

