/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BitTableUtil;
import org.apache.lucene.util.fst.BytesStore;
import org.apache.lucene.util.fst.FSTStore;
import org.apache.lucene.util.fst.OnHeapFSTStore;
import org.apache.lucene.util.fst.Outputs;

public final class FST<T> {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FST.class);
    final INPUT_TYPE inputType;
    T emptyOutput;
    final BytesStore bytes = null;
    private final FSTStore fstStore;
    private long startNode = -1L;
    public final Outputs<T> outputs;
    private final int version;
    private static final int DEFAULT_MAX_BLOCK_BITS = Constants.JRE_IS_64BIT ? 30 : 28;

    private static boolean flag(int flags, int bit) {
        return (flags & bit) != 0;
    }

    public FST(DataInput metaIn, DataInput in, Outputs<T> outputs) throws IOException {
        this(metaIn, in, outputs, new OnHeapFSTStore(DEFAULT_MAX_BLOCK_BITS));
    }

    public FST(DataInput metaIn, DataInput in, Outputs<T> outputs, FSTStore fstStore) throws IOException {
        this.fstStore = fstStore;
        this.outputs = outputs;
        this.version = CodecUtil.checkHeader(metaIn, "FST", 6, 8);
        if (metaIn.readByte() == 1) {
            BytesStore emptyBytes = new BytesStore(10);
            int numBytes = metaIn.readVInt();
            emptyBytes.copyBytes(metaIn, numBytes);
            BytesReader reader = emptyBytes.getReverseReader();
            if (numBytes > 0) {
                reader.setPosition(numBytes - 1);
            }
            this.emptyOutput = outputs.readFinalOutput(reader);
        } else {
            this.emptyOutput = null;
        }
        byte t = metaIn.readByte();
        switch (t) {
            case 0: {
                this.inputType = INPUT_TYPE.BYTE1;
                break;
            }
            case 1: {
                this.inputType = INPUT_TYPE.BYTE2;
                break;
            }
            case 2: {
                this.inputType = INPUT_TYPE.BYTE4;
                break;
            }
            default: {
                throw new CorruptIndexException("invalid input type " + t, in);
            }
        }
        this.startNode = metaIn.readVLong();
        long numBytes = metaIn.readVLong();
        this.fstStore.init(in, numBytes);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(input=" + this.inputType + ",output=" + this.outputs;
    }

    public int readLabel(DataInput in) throws IOException {
        int v = this.inputType == INPUT_TYPE.BYTE1 ? in.readByte() & 0xFF : (this.inputType == INPUT_TYPE.BYTE2 ? (this.version < 8 ? Short.reverseBytes(in.readShort()) & 0xFFFF : in.readShort() & 0xFFFF) : in.readVInt());
        return v;
    }

    public static <T> boolean targetHasArcs(Arc<T> arc) {
        return arc.target() > 0L;
    }

    private static int getNumPresenceBytes(int labelRange) {
        assert (labelRange >= 0);
        return labelRange + 7 >> 3;
    }

    private void readPresenceBytes(Arc<T> arc, BytesReader in) throws IOException {
        assert (arc.bytesPerArc() > 0);
        assert (arc.nodeFlags() == 64);
        arc.bitTableStart = in.getPosition();
        in.skipBytes(FST.getNumPresenceBytes(arc.numArcs()));
    }

    public Arc<T> getFirstArc(Arc<T> arc) {
        T NO_OUTPUT = this.outputs.getNoOutput();
        if (this.emptyOutput != null) {
            arc.flags = (byte)3;
            arc.nextFinalOutput = this.emptyOutput;
            if (this.emptyOutput != NO_OUTPUT) {
                arc.flags = (byte)(arc.flags() | 0x20);
            }
        } else {
            arc.flags = (byte)2;
            arc.nextFinalOutput = NO_OUTPUT;
        }
        arc.output = NO_OUTPUT;
        arc.target = this.startNode;
        return arc;
    }

    private long readUnpackedNodeTarget(BytesReader in) throws IOException {
        return in.readVLong();
    }

    public Arc<T> readFirstRealTargetArc(long nodeAddress, Arc<T> arc, BytesReader in) throws IOException {
        in.setPosition(nodeAddress);
        byte flags = arc.nodeFlags = in.readByte();
        if (flags == 32 || flags == 64) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readVInt();
            arc.arcIdx = -1;
            if (flags == 64) {
                this.readPresenceBytes(arc, in);
                arc.firstLabel = this.readLabel(in);
                arc.presenceIndex = -1;
            }
            arc.posArcsStart = in.getPosition();
        } else {
            arc.nextArc = nodeAddress;
            arc.bytesPerArc = 0;
        }
        return this.readNextRealArc(arc, in);
    }

    public Arc<T> readArcByDirectAddressing(Arc<T> arc, BytesReader in, int rangeIndex) throws IOException {
        assert (Arc.BitTable.assertIsValid(arc, in));
        assert (rangeIndex >= 0 && rangeIndex < arc.numArcs());
        assert (Arc.BitTable.isBitSet(rangeIndex, arc, in));
        int presenceIndex = Arc.BitTable.countBitsUpTo(rangeIndex, arc, in);
        return this.readArcByDirectAddressing(arc, in, rangeIndex, presenceIndex);
    }

    private Arc<T> readArcByDirectAddressing(Arc<T> arc, BytesReader in, int rangeIndex, int presenceIndex) throws IOException {
        in.setPosition(arc.posArcsStart() - (long)presenceIndex * (long)arc.bytesPerArc());
        arc.arcIdx = rangeIndex;
        arc.presenceIndex = presenceIndex;
        arc.flags = in.readByte();
        return this.readArc(arc, in);
    }

    public Arc<T> readNextRealArc(Arc<T> arc, BytesReader in) throws IOException {
        switch (arc.nodeFlags()) {
            case 32: {
                assert (arc.bytesPerArc() > 0);
                ++arc.arcIdx;
                assert (arc.arcIdx() >= 0 && arc.arcIdx() < arc.numArcs());
                in.setPosition(arc.posArcsStart() - (long)arc.arcIdx() * (long)arc.bytesPerArc());
                arc.flags = in.readByte();
                break;
            }
            case 64: {
                assert (Arc.BitTable.assertIsValid(arc, in));
                assert (arc.arcIdx() == -1 || Arc.BitTable.isBitSet(arc.arcIdx(), arc, in));
                int nextIndex = Arc.BitTable.nextBitSet(arc.arcIdx(), arc, in);
                return this.readArcByDirectAddressing(arc, in, nextIndex, arc.presenceIndex + 1);
            }
            default: {
                assert (arc.bytesPerArc() == 0);
                in.setPosition(arc.nextArc());
                arc.flags = in.readByte();
            }
        }
        return this.readArc(arc, in);
    }

    private Arc<T> readArc(Arc<T> arc, BytesReader in) throws IOException {
        arc.label = arc.nodeFlags() == 64 ? arc.firstLabel() + arc.arcIdx() : this.readLabel(in);
        arc.output = arc.flag(16) ? this.outputs.read(in) : this.outputs.getNoOutput();
        arc.nextFinalOutput = arc.flag(32) ? this.outputs.readFinalOutput(in) : this.outputs.getNoOutput();
        if (arc.flag(8)) {
            arc.target = arc.flag(1) ? -1L : 0L;
            arc.nextArc = in.getPosition();
        } else if (arc.flag(4)) {
            arc.nextArc = in.getPosition();
            if (!arc.flag(2)) {
                if (arc.bytesPerArc() == 0) {
                    this.seekToNextNode(in);
                } else {
                    int numArcs = arc.nodeFlags == 64 ? Arc.BitTable.countBits(arc, in) : arc.numArcs();
                    in.setPosition(arc.posArcsStart() - (long)arc.bytesPerArc() * (long)numArcs);
                }
            }
            arc.target = in.getPosition();
        } else {
            arc.target = this.readUnpackedNodeTarget(in);
            arc.nextArc = in.getPosition();
        }
        return arc;
    }

    public Arc<T> findTargetArc(int labelToMatch, Arc<T> follow, Arc<T> arc, BytesReader in) throws IOException {
        if (labelToMatch == -1) {
            if (follow.isFinal()) {
                if (follow.target() <= 0L) {
                    arc.flags = (byte)2;
                } else {
                    arc.flags = 0;
                    arc.nextArc = follow.target();
                }
                arc.output = follow.nextFinalOutput();
                arc.label = -1;
                arc.nodeFlags = arc.flags;
                return arc;
            }
            return null;
        }
        if (!FST.targetHasArcs(follow)) {
            return null;
        }
        in.setPosition(follow.target());
        byte flags = arc.nodeFlags = in.readByte();
        if (flags == 64) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readVInt();
            this.readPresenceBytes(arc, in);
            arc.firstLabel = this.readLabel(in);
            arc.posArcsStart = in.getPosition();
            int arcIndex = labelToMatch - arc.firstLabel();
            if (arcIndex < 0 || arcIndex >= arc.numArcs()) {
                return null;
            }
            if (!Arc.BitTable.isBitSet(arcIndex, arc, in)) {
                return null;
            }
            return this.readArcByDirectAddressing(arc, in, arcIndex);
        }
        if (flags == 32) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readVInt();
            arc.posArcsStart = in.getPosition();
            int low = 0;
            int high = arc.numArcs() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                in.setPosition(arc.posArcsStart() - (long)(arc.bytesPerArc() * mid + 1));
                int midLabel = this.readLabel(in);
                int cmp = midLabel - labelToMatch;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                arc.arcIdx = mid - 1;
                return this.readNextRealArc(arc, in);
            }
            return null;
        }
        this.readFirstRealTargetArc(follow.target(), arc, in);
        while (arc.label() != labelToMatch) {
            if (arc.label() > labelToMatch) {
                return null;
            }
            if (arc.isLast()) {
                return null;
            }
            this.readNextRealArc(arc, in);
        }
        return arc;
    }

    private void seekToNextNode(BytesReader in) throws IOException {
        byte flags;
        do {
            flags = in.readByte();
            this.readLabel(in);
            if (FST.flag(flags, 16)) {
                this.outputs.skipOutput(in);
            }
            if (FST.flag(flags, 32)) {
                this.outputs.skipFinalOutput(in);
            }
            if (FST.flag(flags, 8) || FST.flag(flags, 4)) continue;
            this.readUnpackedNodeTarget(in);
        } while (!FST.flag(flags, 2));
    }

    public BytesReader getBytesReader() {
        if (this.fstStore != null) {
            return this.fstStore.getReverseBytesReader();
        }
        return this.bytes.getReverseReader();
    }

    public static abstract class BytesReader
    extends DataInput {
        public abstract long getPosition();

        public abstract void setPosition(long var1);
    }

    public static final class Arc<T> {
        private int label;
        private T output;
        private long target;
        private byte flags;
        private T nextFinalOutput;
        private long nextArc;
        private byte nodeFlags;
        private int bytesPerArc;
        private long posArcsStart;
        private int arcIdx;
        private int numArcs;
        private long bitTableStart;
        private int firstLabel;
        private int presenceIndex;

        public Arc<T> copyFrom(Arc<T> other) {
            this.label = other.label();
            this.target = other.target();
            this.flags = other.flags();
            this.output = other.output();
            this.nextFinalOutput = other.nextFinalOutput();
            this.nextArc = other.nextArc();
            this.nodeFlags = other.nodeFlags();
            this.bytesPerArc = other.bytesPerArc();
            this.posArcsStart = other.posArcsStart();
            this.arcIdx = other.arcIdx();
            this.numArcs = other.numArcs();
            this.bitTableStart = other.bitTableStart;
            this.firstLabel = other.firstLabel();
            this.presenceIndex = other.presenceIndex;
            return this;
        }

        boolean flag(int flag) {
            return FST.flag(this.flags, flag);
        }

        public boolean isLast() {
            return this.flag(2);
        }

        public boolean isFinal() {
            return this.flag(1);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(" target=").append(this.target());
            b.append(" label=0x").append(Integer.toHexString(this.label()));
            if (this.flag(1)) {
                b.append(" final");
            }
            if (this.flag(2)) {
                b.append(" last");
            }
            if (this.flag(4)) {
                b.append(" targetNext");
            }
            if (this.flag(8)) {
                b.append(" stop");
            }
            if (this.flag(16)) {
                b.append(" output=").append(this.output());
            }
            if (this.flag(32)) {
                b.append(" nextFinalOutput=").append(this.nextFinalOutput());
            }
            if (this.bytesPerArc() != 0) {
                b.append(" arcArray(idx=").append(this.arcIdx()).append(" of ").append(this.numArcs()).append(")").append("(").append(this.nodeFlags() == 64 ? "da" : "bs").append(")");
            }
            return b.toString();
        }

        public int label() {
            return this.label;
        }

        public T output() {
            return this.output;
        }

        public long target() {
            return this.target;
        }

        public byte flags() {
            return this.flags;
        }

        public T nextFinalOutput() {
            return this.nextFinalOutput;
        }

        long nextArc() {
            return this.nextArc;
        }

        public int arcIdx() {
            return this.arcIdx;
        }

        public byte nodeFlags() {
            return this.nodeFlags;
        }

        public long posArcsStart() {
            return this.posArcsStart;
        }

        public int bytesPerArc() {
            return this.bytesPerArc;
        }

        public int numArcs() {
            return this.numArcs;
        }

        int firstLabel() {
            return this.firstLabel;
        }

        static class BitTable {
            static boolean isBitSet(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.isBitSet(bitIndex, in);
            }

            static int countBits(Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.countBits(FST.getNumPresenceBytes(arc.numArcs()), in);
            }

            static int countBitsUpTo(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.countBitsUpTo(bitIndex, in);
            }

            static int nextBitSet(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.nextBitSet(bitIndex, FST.getNumPresenceBytes(arc.numArcs()), in);
            }

            static boolean assertIsValid(Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.bytesPerArc() > 0);
                assert (arc.nodeFlags() == 64);
                assert (BitTable.isBitSet(0, arc, in));
                assert (BitTable.isBitSet(arc.numArcs() - 1, arc, in));
                assert (BitTable.nextBitSet(arc.numArcs() - 1, arc, in) == -1);
                return true;
            }
        }
    }

    public static final class INPUT_TYPE
    extends Enum<INPUT_TYPE> {
        public static final /* enum */ INPUT_TYPE BYTE1 = new INPUT_TYPE();
        public static final /* enum */ INPUT_TYPE BYTE2 = new INPUT_TYPE();
        public static final /* enum */ INPUT_TYPE BYTE4 = new INPUT_TYPE();
        private static final /* synthetic */ INPUT_TYPE[] $VALUES;

        static {
            $VALUES = new INPUT_TYPE[]{BYTE1, BYTE2, BYTE4};
        }
    }
}

