/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BytesStore;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTStore;
import org.apache.lucene.util.fst.ReverseBytesReader;

public final class OnHeapFSTStore
implements FSTStore {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OnHeapFSTStore.class);
    private BytesStore bytes;
    private byte[] bytesArray;
    private final int maxBlockBits;

    public OnHeapFSTStore(int maxBlockBits) {
        if (maxBlockBits < 1 || maxBlockBits > 30) {
            throw new IllegalArgumentException("maxBlockBits should be 1 .. 30; got " + maxBlockBits);
        }
        this.maxBlockBits = maxBlockBits;
    }

    @Override
    public void init(DataInput in, long numBytes) throws IOException {
        if (numBytes > (long)(1 << this.maxBlockBits)) {
            this.bytes = new BytesStore(this.maxBlockBits);
            this.bytes.copyBytes(in, numBytes);
        } else {
            this.bytesArray = new byte[(int)numBytes];
            in.readBytes(this.bytesArray, 0, this.bytesArray.length);
        }
    }

    @Override
    public FST.BytesReader getReverseBytesReader() {
        if (this.bytesArray != null) {
            return new ReverseBytesReader(this.bytesArray);
        }
        return this.bytes.getReverseReader();
    }
}

