/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.fst.Outputs;

public final class PositiveIntOutputs
extends Outputs<Long> {
    private static final Long NO_OUTPUT = new Long(0L);
    private static final PositiveIntOutputs singleton = new PositiveIntOutputs();

    private PositiveIntOutputs() {
    }

    public static PositiveIntOutputs getSingleton() {
        return singleton;
    }

    @Override
    public Long read(DataInput in) throws IOException {
        long v = in.readVLong();
        if (v == 0L) {
            return NO_OUTPUT;
        }
        return v;
    }

    @Override
    public Long getNoOutput() {
        return NO_OUTPUT;
    }

    public String toString() {
        return "PositiveIntOutputs";
    }
}

