/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtName;

public class KtMacroBody
extends KtTokenList {
    public static final KtMacroBody NULL = null;
    public static final KtMacroBody EMPTY = new KtMacroBody();
    private static final String PREP = "->";
    private static final int PLEN = "->".length();

    public KtMacroBody() {
    }

    public KtMacroBody(KtToken[] tokens) {
        super(tokens);
    }

    public KtMacroBody(KtToken[] tokens, int offset, int count) {
        super(tokens, offset, count);
    }

    public KtMacroBody(KtToken tok) {
        super(tok);
    }

    public KtMacroBody(String str) {
        super(str);
    }

    public KtMacroBody(KtName name) {
        super(name);
    }

    @Override
    public void addOn(KtLog log) {
        log.add(PREP);
        super.addOn(log);
    }

    @Override
    public void addOn(KtLog log, int maxCount) {
        if (maxCount > PLEN) {
            log.add(PREP);
            super.addOn(log, maxCount - PLEN);
        } else if (maxCount > 0) {
            log.add(PREP.substring(0, maxCount));
        }
    }

    @Override
    public void addContext(KtLog left, KtLog right, int pos, int maxCount) {
        if (maxCount > PLEN) {
            left.add(PREP);
            super.addContext(left, right, pos, maxCount - PLEN);
        } else if (maxCount > 0) {
            left.add(PREP.substring(0, maxCount));
        }
    }

    static class KtParamToken
    extends KtToken {
        private final int number;
        private final KtCharCode code;

        public KtParamToken(int number, KtCharCode code) {
            this.number = number;
            this.code = code;
        }

        @Override
        public boolean isMacroParameter() {
            return true;
        }

        @Override
        public int macroParameterNumber() {
            return this.number;
        }

        @Override
        public boolean match(KtToken tok) {
            return this.number == tok.macroParameterNumber();
        }

        @Override
        public void addOn(KtLog log) {
            log.add(this.code);
            log.add(0 <= this.number && this.number < 9 ? Character.forDigit(this.number + 1, 10) : (char)'!');
        }
    }

    public static class KtBuffer
    extends KtTokenList.KtBuffer {
        public KtBuffer() {
        }

        public KtBuffer(int initCap) {
            super(initCap);
        }

        public KtBuffer(int initCap, int capIncrement) {
            super(initCap, capIncrement);
        }

        public KtTokenList.KtBuffer appendParam(int digit, KtCharCode matchCode) {
            return this.append(new KtParamToken(digit, matchCode));
        }

        public KtMacroBody toMacroBody() {
            if (super.length() == 0) {
                return EMPTY;
            }
            Object[] tokens = new KtToken[super.length()];
            this.data.copyInto(tokens);
            return new KtMacroBody((KtToken[])tokens);
        }

        @Override
        public KtTokenList toTokenList() {
            return this.toMacroBody();
        }
    }
}

