/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.io;

import com.whitemagicsoftware.keentype.io.KtResourceWalker;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KtClassPathResources {
    private static final Map<URI, String> RESOURCES = new HashMap<URI, String>(256);
    public static final String GLOB_FONTS = "**.{ttf,otf,tfm}";
    public static final String GLOB_TEX = "**.{tex}";

    public static Optional<URI> getResource(Pattern regex) {
        for (Map.Entry<URI, String> resource : RESOURCES.entrySet()) {
            Matcher matcher = regex.matcher(resource.getValue());
            if (!matcher.matches()) continue;
            return Optional.of(resource.getKey());
        }
        return Optional.empty();
    }

    private static void accept(Path path) {
        RESOURCES.put(path.toUri(), path.toAbsolutePath().toString());
    }

    static {
        try {
            KtResourceWalker.walk("fonts", GLOB_FONTS, KtClassPathResources::accept);
            KtResourceWalker.walk("base", GLOB_TEX, KtClassPathResources::accept);
            KtResourceWalker.walk("ext", GLOB_TEX, KtClassPathResources::accept);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

