/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtAnyBoxedNode;
import com.whitemagicsoftware.keentype.node.KtBreakingCntx;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtHorizIterator;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtSettingContext;
import com.whitemagicsoftware.keentype.node.KtTypesetter;
import com.whitemagicsoftware.keentype.node.KtVisibleSummarizer;

public class KtDiscretionaryNode
extends KtAnyBoxedNode {
    public static final int MAX_LIST_LENGTH = 255;
    public static final int MAX_LIST_RECONS_LENGTH = 127;
    public static final KtDiscretionaryNode EMPTY = new KtDiscretionaryNode(KtNodeList.EMPTY, KtNodeList.EMPTY, KtNodeList.EMPTY);
    protected final KtNodeList pre;
    protected final KtNodeList post;
    protected final KtNodeList list;

    public KtDiscretionaryNode(KtNodeList pre, KtNodeList post, KtNodeList list) {
        super(KtHorizIterator.naturalSizes(list.nodes()));
        this.pre = pre;
        this.post = post;
        this.list = list;
    }

    @Override
    public boolean hasKern() {
        KtNode last = this.list.lastNode();
        return last != KtNode.NULL && last.hasKern();
    }

    @Override
    public KtDimen getKern() {
        KtNode last = this.list.lastNode();
        return last != KtNode.NULL ? last.getKern() : KtDimen.NULL;
    }

    @Override
    public KtDimen getItalCorr() {
        KtNode last = this.list.lastNode();
        return last != KtNode.NULL ? last.getItalCorr() : KtDimen.NULL;
    }

    @Override
    public KtFontMetric addShortlyOn(KtLog log, KtFontMetric metric) {
        return this.post.addShortlyOn(log, this.pre.addShortlyOn(log, metric));
    }

    @Override
    public void addOn(KtLog log, KtCntxLog cntx) {
        log.addEsc(this.getDesc());
        if (!this.list.isEmpty()) {
            log.add(" replacing ").add(this.list.length());
        }
        cntx.addOn(log, this.pre.nodes(), '.');
        cntx.addOn(log, this.post.nodes(), '|');
        cntx.addItems(log, this.list.nodes());
    }

    public String getDesc() {
        return "discretionary";
    }

    @Override
    public void typeSet(KtTypesetter setter, KtSettingContext sctx) {
        setter.moveLeft(this.getLeftX());
        KtNodeEnum nodes = this.list.nodes();
        while (nodes.hasMoreNodes()) {
            KtNode node = nodes.nextNode();
            setter.moveRight(node.getLeftX());
            node.typeSet(setter, sctx);
            setter.moveRight(node.getWidth());
        }
        setter.moveLeft(this.getWidth());
    }

    @Override
    public void addBreakDescOn(KtLog log) {
        log.addEsc("discretionary");
    }

    @Override
    public int breakPenalty(KtBreakingCntx brCntx) {
        return this.pre.isEmpty() ? brCntx.exHyphenPenalty() : brCntx.hyphenPenalty();
    }

    @Override
    public boolean isHyphenBreak() {
        return true;
    }

    @Override
    public KtDimen preBreakWidth() {
        return KtHorizIterator.totalWidth(this.pre.nodes());
    }

    @Override
    public KtDimen postBreakWidth() {
        return KtHorizIterator.totalWidth(this.post.nodes());
    }

    @Override
    public KtNodeEnum atBreakReplacement() {
        KtNodeList replacement = new KtNodeList(1 + this.pre.length());
        replacement.append(EMPTY).append(this.pre);
        return replacement.nodes();
    }

    @Override
    public KtNodeEnum postBreakNodes() {
        return this.post.nodes();
    }

    @Override
    public boolean discardsAfter() {
        return this.post.isEmpty();
    }

    @Override
    public void contributeVisible(KtVisibleSummarizer summarizer) {
        summarizer.summarize(this.list.nodes());
    }

    public String toString() {
        return "Discretionary(" + String.valueOf(this.pre) + "; " + String.valueOf(this.post) + "; " + String.valueOf(this.list) + ")";
    }
}

