/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.openssl;

import java.io.IOException;
import net.jsign.bouncycastle.openssl.PEMDecryptor;
import net.jsign.bouncycastle.openssl.PEMDecryptorProvider;
import net.jsign.bouncycastle.openssl.PEMException;
import net.jsign.bouncycastle.openssl.PEMKeyPair;
import net.jsign.bouncycastle.openssl.PEMKeyPairParser;
import net.jsign.bouncycastle.operator.OperatorCreationException;

public class PEMEncryptedKeyPair {
    private final String dekAlgName;
    private final byte[] iv;
    private final byte[] keyBytes;
    private final PEMKeyPairParser parser;

    PEMEncryptedKeyPair(String string, byte[] byArray, byte[] byArray2, PEMKeyPairParser pEMKeyPairParser) {
        this.dekAlgName = string;
        this.iv = byArray;
        this.keyBytes = byArray2;
        this.parser = pEMKeyPairParser;
    }

    public PEMKeyPair decryptKeyPair(PEMDecryptorProvider pEMDecryptorProvider) throws IOException {
        try {
            PEMDecryptor pEMDecryptor = pEMDecryptorProvider.get(this.dekAlgName);
            return this.parser.parse(pEMDecryptor.decrypt(this.keyBytes, this.iv));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new PEMException("cannot create extraction operator: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        catch (Exception exception) {
            throw new PEMException("exception processing key pair: " + exception.getMessage(), exception);
        }
    }
}

