/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.parser;

import com.whitemagicsoftware.keenquotes.lex.LexerFilter;
import com.whitemagicsoftware.keenquotes.parser.Contractions;
import com.whitemagicsoftware.keenquotes.parser.QuoteEmitter;
import com.whitemagicsoftware.keenquotes.parser.Token;
import com.whitemagicsoftware.keenquotes.parser.TokenType;
import com.whitemagicsoftware.keenquotes.parser.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public final class AmbiguityResolver
implements Consumer<Token> {
    private final Consumer<Token> mConsumer;
    private Tree<Token> mTree = new Tree();

    private AmbiguityResolver(Consumer<Token> consumer) {
        assert (consumer != null);
        this.mConsumer = consumer;
    }

    public static void resolve(String text, Contractions contractions, Consumer<Token> consumer, LexerFilter filter) {
        AmbiguityResolver resolver = new AmbiguityResolver(consumer);
        QuoteEmitter.analyze(text, contractions, resolver, filter);
        resolver.resolve();
    }

    @Override
    public void accept(Token token) {
        if (token.isType(TokenType.QUOTE_OPENING_SINGLE) || token.isType(TokenType.QUOTE_OPENING_DOUBLE)) {
            this.mTree = this.mTree.opening(token.copy());
        } else if (token.isType(TokenType.QUOTE_CLOSING_SINGLE) || token.isType(TokenType.QUOTE_CLOSING_DOUBLE)) {
            this.mTree = this.mTree.closing(token.copy());
        } else if (token.isType(TokenType.QUOTE_AMBIGUOUS_DOUBLE)) {
            if (this.mTree.hasOpeningDoubleQuote()) {
                token.setTokenType(TokenType.QUOTE_CLOSING_DOUBLE);
                this.mTree = this.mTree.closing(token.copy());
            } else {
                token.setTokenType(TokenType.QUOTE_OPENING_DOUBLE);
                this.mTree = this.mTree.opening(token.copy());
            }
        } else {
            this.mTree.add(token.copy());
        }
    }

    private void resolve() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.mTree = this.mTree.root();
        this.mTree.visit(this::disambiguate);
        this.mTree.visit(tree -> tree.iterateTokens(tokens::add));
        Collections.sort(tokens);
        this.resolve(tokens);
        this.mTree.visit(this::disambiguate);
        tokens.forEach(this.mConsumer);
    }

    private void resolve(List<Token> tokens) {
        assert (tokens != null);
        boolean leader = false;
        for (Token token : tokens) {
            if (token.isType(TokenType.QUOTE_AMBIGUOUS_LEADING)) {
                leader = true;
                continue;
            }
            if (!leader && token.isType(TokenType.QUOTE_AMBIGUOUS_LAGGING)) {
                token.setTokenType(TokenType.QUOTE_APOSTROPHE);
                continue;
            }
            if (!token.isType(TokenType.QUOTE_AMBIGUOUS_SINGLE)) continue;
            if (this.mTree.hasOpeningSingleQuote()) {
                token.setTokenType(TokenType.QUOTE_CLOSING_SINGLE);
                this.mTree = this.mTree.closing(token);
                continue;
            }
            token.setTokenType(TokenType.QUOTE_OPENING_SINGLE);
            this.mTree = this.mTree.opening(token);
        }
    }

    private void disambiguate(Tree<Token> tree) {
        int countLeading = tree.count(TokenType.QUOTE_AMBIGUOUS_LEADING);
        int countLagging = tree.count(TokenType.QUOTE_AMBIGUOUS_LAGGING);
        int countSingles = tree.count(TokenType.QUOTE_AMBIGUOUS_SINGLE);
        if (tree.hasOpeningSingleQuote() && !tree.hasClosingSingleQuote()) {
            if (countSingles == 0 && countLeading == 0 && countLagging == 1) {
                tree.replaceAll(TokenType.QUOTE_AMBIGUOUS_LAGGING, TokenType.QUOTE_CLOSING_SINGLE);
            } else if (countSingles == 1 && countLagging == 0) {
                tree.replaceAll(TokenType.QUOTE_AMBIGUOUS_SINGLE, TokenType.QUOTE_CLOSING_SINGLE);
            }
        }
        if (countSingles == 0 && countLeading == 1 && countLagging == 0 && !tree.hasOpeningSingleQuote() && tree.hasClosingSingleQuote()) {
            tree.replaceAll(TokenType.QUOTE_AMBIGUOUS_LEADING, TokenType.QUOTE_OPENING_SINGLE);
        }
        if (!tree.hasOpeningSingleQuote() && !tree.hasClosingSingleQuote() || tree.isBalanced()) {
            if (countSingles == 0 && countLeading > 0 && countLagging == 0) {
                tree.replaceAll(TokenType.QUOTE_AMBIGUOUS_LEADING, TokenType.QUOTE_APOSTROPHE);
            }
            if (countSingles == 0 && countLeading == 0 && countLagging > 0) {
                tree.replaceAll(TokenType.QUOTE_AMBIGUOUS_LAGGING, TokenType.QUOTE_APOSTROPHE);
            }
        }
    }
}

