/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.base;

import com.whitemagicsoftware.keentype.base.KtBinFraction;

public final class KtDimen
extends KtBinFraction {
    private static final int POINT_SHIFT = 16;
    private static final int MAX_REPR_VALUE = 0x3FFFFFFF;
    public static final double MAX_DOUBLE_VALUE = 20000.0;
    public static final KtDimen NULL = null;
    public static final KtDimen ZERO = KtDimen.valueOf(0);
    public static final KtDimen UNITY = KtDimen.valueOf(1);
    public static final KtDimen MAX_VALUE = new KtDimen(0x3FFFFFFF);
    public static final KtDimen MAX_FROM_DOUBLE = KtDimen.valueOf(20000.0);
    public static final int REPR_UNITY = 65536;
    public static final KtPar NULL_PAR = null;
    public static final int UNI_BAD = 100;
    public static final int INF_BAD = 10000;
    public static final int DEPLORABLE = 100000;
    public static final int OVERFULL_BAD = 1000000;
    public static final int AWFUL_BAD = 0x3FFFFFFF;

    private KtDimen(int val) {
        super(val);
    }

    @Override
    protected int pointShift() {
        return 16;
    }

    public static void set(KtPar par, KtDimen val) {
        if (par != NULL_PAR) {
            par.value = val;
        }
    }

    private static int makeRepr(int num) {
        return num << 16;
    }

    private static int makeRepr(int num, int den) {
        return (int)(((long)num << 16) / (long)den);
    }

    private static int makeRepr(KtBinFraction x) {
        return KtDimen.makeRepr(x, 16);
    }

    private static int makeRepr(double d) {
        if ((d *= 65536.0) >= 1.073741823E9) {
            return 0x3FFFFFFF;
        }
        if (d <= -1.073741823E9) {
            return -1073741823;
        }
        return KtDimen.round(d);
    }

    private static int round(double d) {
        return (int)(d >= 0.0 ? d + 0.5 : d - 0.5);
    }

    public static KtDimen valueOf(KtDimen d) {
        return new KtDimen(d.value);
    }

    public static KtDimen valueOf(int num) {
        return new KtDimen(KtDimen.makeRepr(num));
    }

    public static KtDimen valueOf(int num, int den) {
        return new KtDimen(KtDimen.makeRepr(num, den));
    }

    public static KtDimen valueOf(KtBinFraction x) {
        return new KtDimen(KtDimen.makeRepr(x));
    }

    public static KtDimen valueOf(double d) {
        return new KtDimen(KtDimen.makeRepr(d));
    }

    public static KtDimen shiftedValueOf(int num, int offs) {
        return new KtDimen((offs += 16) < 0 ? num >> -offs : num << offs);
    }

    public static KtDimen valueOf(String s) throws NumberFormatException {
        boolean negative;
        int pointIndex = s.indexOf(46);
        if (pointIndex < 0) {
            return new KtDimen(KtDimen.makeRepr(Integer.parseInt(s)));
        }
        long val = Integer.parseInt(s.substring(0, pointIndex));
        int SHIFT = 17;
        int frac = 0;
        int i = pointIndex + 17 + 1;
        if (i > s.length()) {
            i = s.length();
        }
        while (--i > pointIndex) {
            int digit = Character.digit(s.charAt(i), 10);
            if (digit < 0) {
                throw new NumberFormatException(s);
            }
            frac = (frac + (digit << 17)) / 10;
        }
        boolean bl = negative = val < 0L;
        if (negative) {
            val = -val;
        }
        val <<= 16;
        if ((val |= (long)(frac + 1 >>> 1)) > 0x3FFFFFFFL) {
            throw new NumberFormatException(s);
        }
        return new KtDimen(negative ? (int)(-val) : (int)val);
    }

    public int sign() {
        return Integer.compare(this.value, 0);
    }

    public boolean isZero() {
        return this.value == 0;
    }

    public boolean equals(KtDimen d) {
        return this.value == d.value;
    }

    public boolean equals(int num) {
        return this.value == KtDimen.makeRepr(num);
    }

    public boolean equals(int num, int den) {
        return this.value == KtDimen.makeRepr(num, den);
    }

    public boolean equals(KtBinFraction x) {
        return this.value == KtDimen.makeRepr(x);
    }

    public boolean equals(double d) {
        return this.value == KtDimen.makeRepr(d);
    }

    public boolean lessThan(KtDimen d) {
        return this.value < d.value;
    }

    public boolean lessThan(int num) {
        return this.value < KtDimen.makeRepr(num);
    }

    public boolean lessThan(int num, int den) {
        return this.value < KtDimen.makeRepr(num, den);
    }

    public boolean lessThan(KtBinFraction x) {
        return this.value < KtDimen.makeRepr(x);
    }

    public boolean lessThan(double d) {
        return this.value < KtDimen.makeRepr(d);
    }

    public boolean moreThan(KtDimen d) {
        return this.value > d.value;
    }

    public boolean moreThan(int num) {
        return this.value > KtDimen.makeRepr(num);
    }

    public boolean moreThan(int num, int den) {
        return this.value > KtDimen.makeRepr(num, den);
    }

    public boolean moreThan(KtBinFraction x) {
        return this.value > KtDimen.makeRepr(x);
    }

    public boolean moreThan(double d) {
        return this.value > KtDimen.makeRepr(d);
    }

    public KtDimen negative() {
        return new KtDimen(-this.value);
    }

    public KtDimen absolute() {
        return this.value < 0 ? new KtDimen(-this.value) : this;
    }

    public KtDimen plus(KtDimen d) {
        return new KtDimen(this.value + d.value);
    }

    public KtDimen plus(int num) {
        return new KtDimen(this.value + KtDimen.makeRepr(num));
    }

    public KtDimen plus(int num, int den) {
        return new KtDimen(this.value + KtDimen.makeRepr(num, den));
    }

    public KtDimen plus(KtBinFraction x) {
        return new KtDimen(this.value + KtDimen.makeRepr(x));
    }

    public KtDimen plus(double d) {
        return new KtDimen(this.value + KtDimen.makeRepr(d));
    }

    public KtDimen minus(KtDimen d) {
        return new KtDimen(this.value - d.value);
    }

    public KtDimen minus(int num) {
        return new KtDimen(this.value - KtDimen.makeRepr(num));
    }

    public KtDimen minus(int num, int den) {
        return new KtDimen(this.value - KtDimen.makeRepr(num, den));
    }

    public KtDimen minus(KtBinFraction x) {
        return new KtDimen(this.value - KtDimen.makeRepr(x));
    }

    public KtDimen minus(double d) {
        return new KtDimen(this.value - KtDimen.makeRepr(d));
    }

    public KtDimen times(KtDimen d) {
        return new KtDimen((int)((long)this.value * (long)d.value >> 16));
    }

    public KtDimen times(int num) {
        return new KtDimen(this.value * num);
    }

    public KtDimen times(int num, int den) {
        return new KtDimen((int)((long)this.value * (long)num / (long)den));
    }

    public KtDimen times(KtBinFraction x) {
        return new KtDimen(this.reprTimes(x));
    }

    public KtDimen times(double d) {
        return new KtDimen(KtDimen.round((double)this.value * d));
    }

    public KtDimen limitedTimes(double d) {
        double limit = 1.0E9;
        double v = (double)this.value * d;
        if (v > 1.0E9) {
            v = 1.0E9;
        } else if (v < -1.0E9) {
            v = -1.0E9;
        }
        return new KtDimen(KtDimen.round(v));
    }

    public KtDimen over(KtDimen d) {
        return new KtDimen((int)(((long)this.value << 16) / (long)d.value));
    }

    public KtDimen over(int num) {
        return new KtDimen(this.value / num);
    }

    public KtDimen over(int num, int den) {
        return new KtDimen((int)((long)this.value * (long)den / (long)num));
    }

    public KtDimen over(KtBinFraction x) {
        return new KtDimen(this.reprOver(x));
    }

    public KtDimen over(double d) {
        return new KtDimen(KtDimen.round((double)this.value / d));
    }

    public double doubleOver(KtDimen d) {
        return (double)this.value / (double)d.value;
    }

    public KtDimen roundDivide(int num) {
        return new KtDimen((int)((2L * (long)this.value + (long)num) / (2L * (long)num)));
    }

    public int divide(KtDimen d) {
        return this.value / d.value;
    }

    public KtDimen modulo(KtDimen d) {
        return new KtDimen(this.value % d.value);
    }

    public KtDimen shifted(int offs) {
        return new KtDimen(offs < 0 ? this.value >> -offs : this.value << offs);
    }

    public KtDimen min(KtDimen d) {
        return this.moreThan(d) ? d : this;
    }

    public KtDimen max(KtDimen d) {
        return this.lessThan(d) ? d : this;
    }

    public KtDimen halved() {
        return new KtDimen((this.value + 1 & 0xFFFFFFFE) / 2);
    }

    public int toInt() {
        return this.value >> 16;
    }

    public int toInt(int den) {
        return (int)((long)this.value * (long)den >> 16);
    }

    public double toDouble() {
        return (double)this.value / 65536.0;
    }

    public String toString(String unit) {
        return this.toString() + unit;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int v = this.value;
        int MASK = 65535;
        if (v < 0) {
            buf.append('-');
            v = -v;
        }
        buf.append(v >>> 16);
        buf.append('.');
        v = 10 * (v & 0xFFFF) + 5;
        int delta = 10;
        do {
            if (delta > 65536) {
                v += 32768 - delta / 2;
            }
            buf.append(Character.forDigit(v >>> 16, 10));
        } while ((v = 10 * (v & 0xFFFF)) > (delta *= 10));
        return buf.toString();
    }

    public int hashCode() {
        return 6128 * this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof KtDimen)) return false;
        KtDimen d = (KtDimen)o;
        if (d.value != this.value) return false;
        return true;
    }

    public int badness(KtDimen limit) {
        int ratio;
        int total = this.value;
        int sum = limit.value;
        if (total == 0) {
            return 0;
        }
        if (total < 0) {
            total = -total;
            sum = -sum;
        }
        if (sum <= 0) {
            return 10000;
        }
        if (total <= 7230584) {
            ratio = total * 297 / sum;
        } else if (sum >= 1663497) {
            ratio = total / (sum / 297);
        } else {
            return 10000;
        }
        return ratio > 1290 ? 10000 : (ratio * ratio * ratio + 131072) / 262144;
    }

    public String toSp() {
        return Integer.toString(this.value);
    }

    public static class KtPar {
        private KtDimen value;

        public KtPar() {
            this.value = NULL;
        }

        public KtPar(KtDimen val) {
            this.value = val;
        }

        public void set(KtDimen val) {
            this.value = val;
        }

        public KtDimen get() {
            return this.value;
        }
    }

    public static interface KtProvider {
        public KtDimen getDimenValue();
    }
}

