/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtEofToken;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtTreatBox;
import java.io.Serializable;

public abstract class KtCommand
extends KtCommandBase
implements Serializable,
KtLoggable {
    public static final KtCommand NULL = null;
    public static final int BOOLP_TRACING_COMMANDS = KtCommand.newBoolParam();
    public static final int TOKSP_EVERY_JOB = KtCommand.newToksParam();
    private static boolean working;
    private static boolean dumping;

    public boolean expandable() {
        return false;
    }

    public void doExpansion(KtToken src) {
        throw new RuntimeException("not expandable");
    }

    public void addExpandable(KtLog log) {
        this.addExpandable(log, false);
    }

    public void addExpandable(KtLog log, boolean full) {
        this.addOn(log);
    }

    public void addExpandable(KtLog log, int maxCount) {
        this.addExpandable(log, true);
    }

    public KtCommand meaning(boolean expOK) {
        return this;
    }

    public boolean sameAs(KtCommand cmd) {
        return cmd == this;
    }

    public KtToken origin() {
        return KtToken.NULL;
    }

    public final void execute(KtToken src) {
        if (KtCommand.getConfig().getBoolParam(BOOLP_TRACING_COMMANDS)) {
            KtCommand.traceCommand(this);
        }
        this.exec(src);
    }

    public final void execute(KtToken src, int prefixes) {
        this.exec(src, prefixes);
    }

    public abstract void exec(KtToken var1);

    public void exec(KtToken src, int prefixes) {
        KtCommand.backToken(src);
        KtCommand.error("NonPrefixCommand", this);
    }

    public boolean immedExec(KtToken src) {
        return false;
    }

    public void perform(int operation, boolean glob, KtCommand after) {
        KtCommand.error("CantAfterThe", this, after);
    }

    public boolean assignable() {
        return false;
    }

    public void doAssignment(KtToken src, int prefixes) {
        throw new RuntimeException("not assignable");
    }

    public boolean isSpacer() {
        return false;
    }

    public boolean isRelax() {
        return false;
    }

    public boolean isLeftBrace() {
        return false;
    }

    public boolean isRightBrace() {
        return false;
    }

    public boolean isMacroParam() {
        return false;
    }

    public boolean isEndCsName() {
        return false;
    }

    public boolean isOuter() {
        return false;
    }

    public boolean isConditional() {
        return false;
    }

    public int endBranchLevel() {
        return 0;
    }

    public boolean isNoBoundary() {
        return false;
    }

    public boolean isMathShift() {
        return false;
    }

    public boolean isTabSkip() {
        return false;
    }

    public boolean isNoAlign() {
        return false;
    }

    public boolean isOmit() {
        return false;
    }

    public boolean isCrCr() {
        return false;
    }

    public boolean isCarRet() {
        return false;
    }

    public boolean isTabMark() {
        return false;
    }

    public boolean isSpan() {
        return false;
    }

    public boolean explosive() {
        return false;
    }

    public void detonate(KtToken src) {
        throw new RuntimeException("not explosive");
    }

    public KtCharCode charCode() {
        return KtCharCode.NULL;
    }

    public KtCharCode charCodeToAdd() {
        return KtCharCode.NULL;
    }

    public boolean appendToks(KtTokenList.KtBuffer buf) {
        return false;
    }

    public boolean hasNumValue() {
        return this.hasDimenValue() || this.hasMuDimenValue();
    }

    public boolean hasDimenValue() {
        return this.hasGlueValue();
    }

    public boolean hasMuDimenValue() {
        return this.hasMuGlueValue();
    }

    public boolean hasGlueValue() {
        return false;
    }

    public boolean hasMuGlueValue() {
        return false;
    }

    public boolean hasToksValue() {
        return false;
    }

    public boolean hasFontTokenValue() {
        return false;
    }

    public boolean hasFontMetricValue() {
        return false;
    }

    public boolean hasRuleValue() {
        return false;
    }

    public boolean hasBoxValue() {
        return false;
    }

    public boolean canMakeBoxValue() {
        return false;
    }

    public boolean hasCrazyValue() {
        return false;
    }

    public boolean hasMathCodeValue() {
        return false;
    }

    public boolean hasDelCodeValue() {
        return false;
    }

    public KtNum getNumValue() {
        if (this.hasDimenValue()) {
            return KtNum.valueOf(this.getDimenValue().toInt(65536));
        }
        if (this.hasMuDimenValue()) {
            KtNum n = KtNum.valueOf(this.getMuDimenValue().toInt(65536));
            KtCommand.muError();
            return n;
        }
        return KtNum.NULL;
    }

    public KtDimen getDimenValue() {
        return this.hasGlueValue() ? this.getGlueValue().getDimen() : KtDimen.NULL;
    }

    public KtDimen getMuDimenValue() {
        return this.hasMuGlueValue() ? this.getMuGlueValue().getDimen() : KtDimen.NULL;
    }

    public KtGlue getGlueValue() {
        return KtGlue.NULL;
    }

    public KtGlue getMuGlueValue() {
        return KtGlue.NULL;
    }

    public KtTokenList getToksValue() {
        return KtTokenList.NULL;
    }

    public KtToken getFontTokenValue() {
        return KtToken.NULL;
    }

    public KtFontMetric getFontMetricValue() {
        return KtFontMetric.NULL;
    }

    public KtBoxSizes getRuleValue() {
        return KtBoxSizes.NULL;
    }

    public KtBox getBoxValue() {
        return KtBox.NULL;
    }

    public void makeBoxValue(KtTreatBox proc) {
        throw new RuntimeException("Cannot make a box");
    }

    public KtGlue getSkipForLeaders() {
        return KtGlue.NULL;
    }

    public int getMathCodeValue() {
        return 0;
    }

    public int getDelCodeValue() {
        return 0;
    }

    public static boolean mainLoop() {
        working = true;
        KtCommand.getConfig().getToksInserter(TOKSP_EVERY_JOB).insertToks();
        do {
            KtToken tok;
            if ((tok = KtCommand.nextExpToken()) == KtToken.NULL || tok instanceof KtEofToken) {
                working = false;
                continue;
            }
            KtCommand.meaningOf(tok).execute(tok);
        } while (working);
        return dumping;
    }

    public static void endMainLoop(boolean dump) {
        dumping = dump;
        working = false;
    }

    public static void cleanUp() {
        KtCommand.ensureOpenLog();
        KtCommand.getTokStack().close();
        KtCommand.finishGroups();
    }
}

