/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.base.KtBoolPar;
import com.whitemagicsoftware.keentype.command.KtContextDisplay;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenizer;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtInputLine;
import com.whitemagicsoftware.keentype.io.KtName;

public class KtInputLineTokenizer
extends KtTokenizer {
    public static final KtInputLineTokenizer NULL = null;
    private final KtInputLine line;
    private final KtTokenMaker maker;
    private final String desc;
    private static final byte NEW_LINE = 0;
    private static final byte MID_LINE = 1;
    private static final byte SKIP_BLANKS = 2;
    private byte state = 0;
    public static final byte ESCAPE = 0;
    public static final byte LETTER = 1;
    public static final byte SPACER = 2;
    public static final byte ENDLINE = 3;
    public static final byte COMMENT = 4;
    public static final byte IGNORE = 5;
    public static final byte OTHER = 6;

    public KtInputLineTokenizer(KtInputLine line, KtTokenMaker maker, String desc) {
        this.line = line;
        this.maker = maker;
        this.desc = desc;
    }

    public void setMidLine() {
        this.state = 1;
    }

    @Override
    public KtToken nextToken(KtBoolPar canExpand) {
        canExpand.set(true);
        return this.nextToken();
    }

    public KtToken nextToken() {
        KtCharCode code;
        block7: while (true) {
            if ((code = this.line.getNext()) == KtInputLine.EOL) {
                return KtToken.NULL;
            }
            switch (this.maker.scanCat(code)) {
                case 0: {
                    code = this.line.getNext();
                    if (code == KtInputLine.EOL) {
                        return this.maker.make(new KtName());
                    }
                    byte cat = this.maker.scanCat(code);
                    if (cat != 1) {
                        this.state = (byte)(cat == 2 ? 2 : 1);
                        return this.maker.make(new KtName(code));
                    }
                    KtName.KtBuffer buf = new KtName.KtBuffer();
                    buf.append(code);
                    while ((code = this.line.peekNext()) != KtInputLine.EOL && this.maker.scanCat(code) == 1) {
                        buf.append(code);
                        this.line.getNext();
                    }
                    this.state = (byte)2;
                    return this.maker.make(buf.toName());
                }
                case 3: {
                    this.line.skipAll();
                    if (this.state == 1) {
                        return this.maker.makeSpace();
                    }
                    if (this.state != 0) continue block7;
                    return this.maker.makePar();
                }
                case 2: {
                    if (this.state != 1) continue block7;
                    this.state = (byte)2;
                    return this.maker.makeSpace();
                }
                case 4: {
                    this.line.skipAll();
                    continue block7;
                }
                case 5: {
                    continue block7;
                }
            }
            break;
        }
        this.state = 1;
        return this.maker.make(code);
    }

    @Override
    public boolean finished() {
        return this.line.empty();
    }

    @Override
    public boolean finishedInsert() {
        return this.line.empty();
    }

    @Override
    public int show(KtContextDisplay disp, boolean force, int lines) {
        disp.normal().startLine().add(this.desc);
        this.line.addContext(disp.left(), disp.right());
        disp.show();
        return 1;
    }

    public static interface KtTokenMaker {
        public byte scanCat(KtCharCode var1);

        public KtToken make(KtName var1);

        public KtToken make(KtCharCode var1);

        public KtToken makeSpace();

        public KtToken makePar();
    }
}

