/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.command.KtCharToken;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;

public class KtLeftBraceToken
extends KtCharToken {
    public static final KtCharCode CODE = KtLeftBraceToken.makeCharCode('{');
    public static final KtLeftBraceToken TOKEN = new KtLeftBraceToken(CODE);
    public static final KtCharToken.KtMaker MAKER = KtLeftBraceToken::new;
    private static KtCommand command;

    public KtLeftBraceToken(KtCharCode code) {
        super(code);
    }

    @Override
    public boolean matchLeftBrace() {
        return true;
    }

    @Override
    public boolean match(KtCharToken tok) {
        return tok instanceof KtLeftBraceToken && tok.match(this.code);
    }

    @Override
    public KtCharToken.KtMaker getMaker() {
        return MAKER;
    }

    @Override
    public String toString() {
        return "<KtLeftBrace: " + String.valueOf(this.code) + ">";
    }

    public static void setCommand(KtCommand cmd) {
        command = cmd;
    }

    @Override
    public KtCommand meaning() {
        return new KtCharToken.KtMeaning(){

            @Override
            public boolean isLeftBrace() {
                return true;
            }

            @Override
            public void exec(KtToken src) {
                command.exec(src);
            }

            @Override
            protected String description() {
                return "begin-group character";
            }
        };
    }
}

