/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.io;

import com.whitemagicsoftware.keentype.io.KtBaseLineOutput;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;

public final class KtBufferLineOutput
extends KtBaseLineOutput
implements KtLoggable,
KtCharCode.KtCodeWriter {
    private final KtCharCode[] buffer;
    private final int maxCount;
    private int pos;
    private final KtCharCode.KtMaker maker;

    public KtBufferLineOutput(int size, int maxCount, KtCharCode.KtMaker maker) {
        this.buffer = new KtCharCode[size];
        this.maxCount = maxCount;
        this.maker = maker;
        this.pos = 0;
    }

    @Override
    public void add(KtCharCode code) {
        code.writeExpCodes(this);
    }

    @Override
    public void add(char chr) {
        this.maker.writeExpCodes(chr, this);
    }

    @Override
    public void writeCode(KtCharCode code) {
        if (this.maxCount <= 0 || this.pos < this.maxCount) {
            this.buffer[this.pos++ % this.buffer.length] = code;
        }
        ++this.charCount;
    }

    public void reset() {
        int i = 0;
        while (i < this.buffer.length) {
            this.buffer[i++] = KtCharCode.NULL;
        }
        this.pos = 0;
        this.resetCount();
    }

    public int size() {
        return this.pos <= this.buffer.length ? this.pos : this.buffer.length;
    }

    public void addOn(KtLog log, int idx) {
        log.add(this.codeAt(idx));
    }

    public void addOn(KtLog log, int beg, int end) {
        while (beg < end) {
            log.add(this.codeAt(beg++));
        }
    }

    @Override
    public void addOn(KtLog log) {
        this.addOn(log, 0, this.size());
    }

    private KtCharCode codeAt(int idx) {
        if (idx >= 0) {
            if (this.pos <= this.buffer.length) {
                if (idx < this.pos) {
                    return this.buffer[idx];
                }
            } else if (idx < this.buffer.length) {
                return this.buffer[(this.pos + idx) % this.buffer.length];
            }
        }
        throw new ArrayIndexOutOfBoundsException("KtBufferLineOutput: index out of range: " + idx);
    }
}

