/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.io;

import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;

public class KtInputLine
implements KtLoggable {
    public static final KtInputLine NULL = null;
    public static final KtCharCode EOL = KtCharCode.NULL;
    private KtCharCode[] codes;
    private final KtMapper mapper;
    private int pos;

    private KtInputLine(KtCharCode[] codes, KtMapper mapper, int pos) {
        this.codes = codes;
        this.mapper = mapper;
        this.pos = pos;
    }

    public KtInputLine(KtCharCode[] codes, KtMapper mapper) {
        this(codes, mapper, 0);
    }

    public KtInputLine(KtMapper mapper) {
        this(new KtCharCode[0], mapper);
    }

    public KtInputLine(String str, KtMapper mapper) {
        int end;
        for (end = str.length(); end > 0 && mapper.ignoreTrailing(str.charAt(end - 1)); --end) {
        }
        this.codes = new KtCharCode[end];
        this.mapper = mapper;
        this.pos = 0;
        for (int i = 0; i < end; ++i) {
            this.codes[i] = mapper.map(str.charAt(i));
        }
    }

    public KtInputLine(KtInputLine line) {
        this(line.codes, line.mapper, line.pos);
    }

    public KtInputLine addEndOfLineChar() {
        KtCharCode elc = this.mapper.endLine();
        if (elc != KtCharCode.NULL) {
            KtCharCode[] newCodes = new KtCharCode[this.codes.length + 1];
            System.arraycopy(this.codes, 0, newCodes, 0, this.codes.length);
            newCodes[this.codes.length] = elc;
            return new KtInputLine(newCodes, this.mapper, this.pos);
        }
        return this;
    }

    public KtInputLine pureRest() {
        KtCharCode[] newCodes = new KtCharCode[this.codes.length - this.pos];
        System.arraycopy(this.codes, this.pos, newCodes, 0, this.codes.length - this.pos);
        return new KtInputLine(newCodes, this.mapper, 0);
    }

    public boolean wasEmpty(boolean addEolc) {
        KtCharCode elc;
        if (addEolc && (elc = this.mapper.endLine()) != KtCharCode.NULL) {
            return this.codes.length == 1 && this.codes[0].match(elc);
        }
        return this.codes.length == 0;
    }

    public boolean empty() {
        return this.pos >= this.codes.length;
    }

    public synchronized void skipSpaces() {
        while (this.pos < this.codes.length && this.codes[this.pos].match(' ')) {
            ++this.pos;
        }
    }

    public synchronized KtCharCode getNextRawCode() {
        return this.pos < this.codes.length ? this.codes[this.pos++] : EOL;
    }

    public synchronized KtCharCode peekNextRawCode() {
        return this.pos < this.codes.length ? this.codes[this.pos] : EOL;
    }

    public synchronized KtCharCode getNext() {
        int len = this.codes.length;
        if (this.pos < len) {
            char c1;
            KtCharCode code = this.codes[this.pos++];
            while (this.pos + 1 < len && code.startsExpand() && code.match(this.codes[this.pos]) && (c1 = this.codes[this.pos + 1].toChar()) != '\uffff' && c1 < '\u0080') {
                int numCode;
                char c2;
                this.pos += 2;
                if (this.pos < len && KtInputLine.isHexDigit(c1) && (c2 = this.codes[this.pos].toChar()) != '\uffff' && KtInputLine.isHexDigit(c2)) {
                    ++this.pos;
                    numCode = (KtInputLine.digitForHex(c1) << 4) + KtInputLine.digitForHex(c2);
                } else {
                    numCode = c1 < '@' ? c1 + 64 : c1 - 64;
                }
                code = this.mapper.map(numCode);
            }
            return code;
        }
        return EOL;
    }

    private static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f';
    }

    private static int digitForHex(char c) {
        return c <= '9' ? c - 48 : c - 97 + 10;
    }

    public synchronized KtCharCode peekNext() {
        int oldPos = this.pos;
        KtCharCode code = this.getNext();
        if (this.pos > oldPos + 1) {
            KtCharCode[] newCodes = new KtCharCode[oldPos + 1 + this.codes.length - this.pos];
            System.arraycopy(this.codes, 0, newCodes, 0, oldPos);
            newCodes[oldPos] = code;
            System.arraycopy(this.codes, this.pos, newCodes, oldPos + 1, this.codes.length - this.pos);
            this.codes = newCodes;
        }
        this.pos = oldPos;
        return code;
    }

    public synchronized void skipAll() {
        this.pos = this.codes.length;
    }

    @Override
    public void addOn(KtLog log) {
        log.add(this.codes, this.pos, this.codes.length - this.pos);
    }

    public void addContext(KtLog left, KtLog right) {
        int end = this.codes.length;
        if (end > 0 && this.codes[end - 1].isEndLine()) {
            --end;
        }
        KtLog log = left;
        for (int i = 0; i < end; ++i) {
            if (i == this.pos) {
                log = right;
            }
            log.add(this.codes[i]);
        }
    }

    public static interface KtMapper {
        public KtCharCode map(char var1);

        public KtCharCode map(int var1);

        public KtCharCode endLine();

        public boolean ignoreTrailing(char var1);
    }
}

