/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.util;

import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.jsign.log4j.util.IndexedStringMap;
import net.jsign.log4j.util.ReadOnlyStringMap;
import net.jsign.log4j.util.StringMap;
import net.jsign.log4j.util.Strings;
import net.jsign.log4j.util.TriConsumer;

public class SortedArrayStringMap
implements IndexedStringMap {
    private static final TriConsumer<String, Object, StringMap> PUT_ALL;
    private static final String[] EMPTY;
    private transient String[] keys = EMPTY;
    private transient Object[] values = EMPTY;
    private transient int size;
    private static final Method setObjectInputFilter;
    private static final Method getObjectInputFilter;
    private static final Method newObjectInputFilter;
    private int threshold;
    private boolean immutable;
    private transient boolean iterating;

    public SortedArrayStringMap() {
        this(4);
    }

    public SortedArrayStringMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must be at least zero but was " + initialCapacity);
        }
        this.threshold = SortedArrayStringMap.ceilingNextPowerOfTwo(initialCapacity == 0 ? 1 : initialCapacity);
    }

    public SortedArrayStringMap(ReadOnlyStringMap other) {
        if (other instanceof SortedArrayStringMap) {
            this.initFrom0((SortedArrayStringMap)other);
        } else if (other != null) {
            this.resize(SortedArrayStringMap.ceilingNextPowerOfTwo(other.size()));
            other.forEach(PUT_ALL, this);
        }
    }

    private void assertNotFrozen() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Frozen collection cannot be modified");
        }
    }

    private void assertNoConcurrentModification() {
        if (this.iterating) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Map<String, String> toMap() {
        HashMap<String, String> result = new HashMap<String, String>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            Object value = this.getValueAt(i);
            result.put(this.getKeyAt(i), value == null ? null : String.valueOf(value));
        }
        return result;
    }

    @Override
    public void freeze() {
        this.immutable = true;
    }

    public int indexOfKey(String key) {
        if (this.keys == EMPTY) {
            return -1;
        }
        if (key == null) {
            return this.nullKeyIndex();
        }
        int start = this.size > 0 && this.keys[0] == null ? 1 : 0;
        return Arrays.binarySearch(this.keys, start, this.size, key);
    }

    private int nullKeyIndex() {
        return this.size > 0 && this.keys[0] == null ? 0 : -1;
    }

    @Override
    public void putValue(String key, Object value) {
        int index;
        this.assertNotFrozen();
        this.assertNoConcurrentModification();
        if (this.keys == EMPTY) {
            this.inflateTable(this.threshold);
        }
        if ((index = this.indexOfKey(key)) >= 0) {
            this.keys[index] = key;
            this.values[index] = value;
        } else {
            this.insertAt(~index, key, value);
        }
    }

    private void insertAt(int index, String key, Object value) {
        this.ensureCapacity();
        System.arraycopy(this.keys, index, this.keys, index + 1, this.size - index);
        System.arraycopy(this.values, index, this.values, index + 1, this.size - index);
        this.keys[index] = key;
        this.values[index] = value;
        ++this.size;
    }

    private void initFrom0(SortedArrayStringMap other) {
        if (this.keys.length < other.size) {
            this.keys = new String[other.threshold];
            this.values = new Object[other.threshold];
        }
        System.arraycopy(other.keys, 0, this.keys, 0, other.size);
        System.arraycopy(other.values, 0, this.values, 0, other.size);
        this.size = other.size;
        this.threshold = other.threshold;
    }

    private void ensureCapacity() {
        if (this.size >= this.threshold) {
            this.resize(this.threshold * 2);
        }
    }

    private void resize(int newCapacity) {
        String[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        this.keys = new String[newCapacity];
        this.values = new Object[newCapacity];
        System.arraycopy(oldKeys, 0, this.keys, 0, this.size);
        System.arraycopy(oldValues, 0, this.values, 0, this.size);
        this.threshold = newCapacity;
    }

    private void inflateTable(int toSize) {
        this.threshold = toSize;
        this.keys = new String[toSize];
        this.values = new Object[toSize];
    }

    public String getKeyAt(int index) {
        if (index < 0 || index >= this.size) {
            return null;
        }
        return this.keys[index];
    }

    public <V> V getValueAt(int index) {
        if (index < 0 || index >= this.size) {
            return null;
        }
        return (V)this.values[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, T> void forEach(TriConsumer<String, ? super V, T> action, T state) {
        this.iterating = true;
        try {
            for (int i = 0; i < this.size; ++i) {
                action.accept(this.keys[i], this.values[i], state);
            }
        }
        finally {
            this.iterating = false;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SortedArrayStringMap)) {
            return false;
        }
        SortedArrayStringMap other = (SortedArrayStringMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!Objects.equals(this.keys[i], other.keys[i])) {
                return false;
            }
            if (Objects.equals(this.values[i], other.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 37;
        result = 31 * result + this.size;
        result = 31 * result + SortedArrayStringMap.hashCode(this.keys, this.size);
        result = 31 * result + SortedArrayStringMap.hashCode(this.values, this.size);
        return result;
    }

    private static int hashCode(Object[] values, int length) {
        int result = 1;
        for (int i = 0; i < length; ++i) {
            result = 31 * result + (values[i] == null ? 0 : values[i].hashCode());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append('{');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.keys[i]).append('=');
            sb.append(this.values[i] == this ? "(this map)" : this.values[i]);
        }
        sb.append('}');
        return sb.toString();
    }

    private static int ceilingNextPowerOfTwo(int x) {
        int BITS_PER_INT = 32;
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    static {
        Method newMethod;
        Method getMethod;
        Method setMethod;
        block5: {
            PUT_ALL = (key, value, contextData) -> contextData.putValue((String)key, value);
            EMPTY = Strings.EMPTY_ARRAY;
            Method[] methods = ObjectInputStream.class.getMethods();
            setMethod = null;
            getMethod = null;
            for (Method method : methods) {
                if (method.getName().equals("setObjectInputFilter")) {
                    setMethod = method;
                    continue;
                }
                if (!method.getName().equals("getObjectInputFilter")) continue;
                getMethod = method;
            }
            newMethod = null;
            try {
                if (setMethod == null) break block5;
                Class<?> clazz = Class.forName("net.jsign.log4j.util.internal.DefaultObjectInputFilter");
                for (Method method : methods = clazz.getMethods()) {
                    if (!method.getName().equals("newInstance") || !Modifier.isStatic(method.getModifiers())) continue;
                    newMethod = method;
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        newObjectInputFilter = newMethod;
        setObjectInputFilter = setMethod;
        getObjectInputFilter = getMethod;
    }
}

