/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.parser;

import com.whitemagicsoftware.keenquotes.lex.Lexeme;
import com.whitemagicsoftware.keenquotes.lex.LexemeGlyph;
import com.whitemagicsoftware.keenquotes.parser.Stem;
import com.whitemagicsoftware.keenquotes.parser.TokenType;
import java.util.Map;

final class Token
implements Comparable<Token>,
Stem {
    private static final Map<TokenType, String> ENTITIES = Map.ofEntries(Map.entry(TokenType.QUOTE_OPENING_SINGLE, "&lsquo;"), Map.entry(TokenType.QUOTE_CLOSING_SINGLE, "&rsquo;"), Map.entry(TokenType.QUOTE_OPENING_DOUBLE, "&ldquo;"), Map.entry(TokenType.QUOTE_CLOSING_DOUBLE, "&rdquo;"), Map.entry(TokenType.QUOTE_STRAIGHT_SINGLE, "'"), Map.entry(TokenType.QUOTE_STRAIGHT_DOUBLE, "\""), Map.entry(TokenType.QUOTE_APOSTROPHE, "&apos;"), Map.entry(TokenType.QUOTE_PRIME_SINGLE, "&prime;"), Map.entry(TokenType.QUOTE_PRIME_DOUBLE, "&Prime;"), Map.entry(TokenType.QUOTE_PRIME_TRIPLE, "&tprime;"), Map.entry(TokenType.QUOTE_PRIME_QUADRUPLE, "&qprime;"));
    private static final Map<TokenType, String> CHARS = Map.ofEntries(Map.entry(TokenType.QUOTE_OPENING_SINGLE, "\u2018"), Map.entry(TokenType.QUOTE_CLOSING_SINGLE, "\u2019"), Map.entry(TokenType.QUOTE_OPENING_DOUBLE, "\u201c"), Map.entry(TokenType.QUOTE_CLOSING_DOUBLE, "\u201d"), Map.entry(TokenType.QUOTE_STRAIGHT_SINGLE, "'"), Map.entry(TokenType.QUOTE_STRAIGHT_DOUBLE, "\""), Map.entry(TokenType.QUOTE_APOSTROPHE, "\u2019"), Map.entry(TokenType.QUOTE_PRIME_SINGLE, "\u2032"), Map.entry(TokenType.QUOTE_PRIME_DOUBLE, "\u2033"), Map.entry(TokenType.QUOTE_PRIME_TRIPLE, "\u2034"), Map.entry(TokenType.QUOTE_PRIME_QUADRUPLE, "\u2057"));
    private static final Map<LexemeGlyph, String> I18N_ENTITIES = Map.ofEntries(Map.entry(LexemeGlyph.LEX_DOUBLE_QUOTE_OPENING_LOW, "&ldquor;"), Map.entry(LexemeGlyph.LEX_DOUBLE_CHEVRON_LEFT, "&laquo;"), Map.entry(LexemeGlyph.LEX_DOUBLE_CHEVRON_RIGHT, "&raquo;"), Map.entry(LexemeGlyph.LEX_SINGLE_CHEVRON_LEFT, "&lsaquo;"), Map.entry(LexemeGlyph.LEX_SINGLE_CHEVRON_RIGHT, "&rsaquo;"));
    public static final Token NONE = new Token(TokenType.NONE, Lexeme.NONE);
    private TokenType mTokenType;
    private final Lexeme mLexeme;

    Token(TokenType tokenType, Lexeme lexeme) {
        assert (tokenType != null);
        assert (lexeme.began() >= 0);
        assert (lexeme.ended() >= lexeme.began());
        this.mTokenType = tokenType;
        this.mLexeme = lexeme;
    }

    Token copy() {
        return new Token(this.mTokenType, this.mLexeme.copy());
    }

    boolean isBefore(Token token) {
        assert (token != null);
        assert (token != NONE);
        return this.mLexeme.ended() <= token.began();
    }

    boolean isAfter(Token token) {
        assert (token != null);
        assert (token != NONE);
        return this.mLexeme.began() > token.ended();
    }

    TokenType getType() {
        return this.mTokenType;
    }

    boolean isType(TokenType tokenType) {
        assert (tokenType != null);
        return this.mTokenType == tokenType;
    }

    int began() {
        return this.mLexeme.began();
    }

    int ended() {
        return this.mLexeme.ended();
    }

    boolean isAmbiguous() {
        return this.mTokenType == TokenType.QUOTE_AMBIGUOUS_SINGLE || this.mTokenType == TokenType.QUOTE_AMBIGUOUS_DOUBLE || this.mTokenType == TokenType.QUOTE_AMBIGUOUS_LEADING || this.mTokenType == TokenType.QUOTE_AMBIGUOUS_LAGGING;
    }

    void setTokenType(TokenType tokenType) {
        assert (this.isAmbiguous());
        assert (tokenType != null);
        this.mTokenType = tokenType;
        assert (!this.isAmbiguous());
    }

    @Override
    public int compareTo(Token that) {
        return this.began() - that.began();
    }

    @Override
    public String toXml() {
        return "<" + String.valueOf((Object)this.mTokenType) + " type='" + this.getType().name() + "' began='" + this.began() + "' ended='" + this.ended() + "' />";
    }

    public String toString(boolean entities) {
        LexemeGlyph glyph = this.mLexeme.getType().glyph();
        return entities ? I18N_ENTITIES.getOrDefault((Object)glyph, ENTITIES.get((Object)this.getType())) : CHARS.getOrDefault((Object)this.getType(), glyph.text());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[mType=" + String.valueOf((Object)this.getType()) + ", mBegan=" + this.began() + ", mEnded=" + this.ended() + "]";
    }
}

