/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.base.KtBoolPar;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtExpandable;
import com.whitemagicsoftware.keentype.command.KtExpandablePrim;
import com.whitemagicsoftware.keentype.command.KtFilePos;
import com.whitemagicsoftware.keentype.command.KtInpTokChecker;
import com.whitemagicsoftware.keentype.command.KtSpaceToken;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtLoggable;

public abstract class KtCondPrim
extends KtExpandablePrim {
    public static final int NOTHING = 0;
    public static final int WAIT = 1;
    public static final int FI = 2;
    public static final int ELSE = 3;
    public static final int OR = 4;
    private static KtCondEntry condTop = KtCondEntry.NULL;

    protected static boolean conforms(int endLev, int limit) {
        return endLev <= limit;
    }

    protected static boolean closesBranch(int endLev) {
        return endLev > 1;
    }

    public KtCondPrim(String name) {
        super(name);
    }

    protected static KtCondEntry pushCond(int limit, KtExpandable curr) {
        KtFilePos fpos = KtCondPrim.getTokStack().filePos();
        condTop = new KtCondEntry(condTop, limit, curr, fpos);
        return condTop;
    }

    protected static void popCond() {
        condTop = KtCondPrim.condTop.next;
    }

    protected static KtCondEntry topCond() {
        return condTop;
    }

    protected static boolean noCond() {
        return condTop == KtCondEntry.NULL;
    }

    public static void cleanUp() {
        while (condTop != KtCondEntry.NULL) {
            normLog.startLine().add('(').addEsc("end").add(" occurred when ");
            KtCondPrim.condTop.curr.addExpandable(normLog);
            if (KtCondPrim.condTop.fpos != KtFilePos.NULL) {
                normLog.add(" on line ").add(KtCondPrim.condTop.fpos.line);
            }
            normLog.add(" was incomplete)");
            KtCondPrim.popCond();
        }
    }

    protected static int skipBranch() {
        int endLev;
        KtBoolPar exp = new KtBoolPar();
        KtLoggable[] params = new KtLoggable[]{KtCondPrim.exp(KtCondPrim.condTop.curr), KtCondPrim.num(KtCondPrim.currLineNumber())};
        KtInpTokChecker savedChk = KtCondPrim.setTokenChecker(new KtSkipToksChecker(params));
        int level = 0;
        while (true) {
            KtToken tok;
            KtCommand cmd;
            if (KtCondPrim.closesBranch(endLev = (cmd = KtCondPrim.meaningOf(tok = KtCondPrim.nextRawToken(exp), exp.get())).endBranchLevel())) {
                if (level == 0) break;
                if (endLev != 2) continue;
                --level;
                continue;
            }
            if (!cmd.isConditional()) continue;
            ++level;
        }
        KtCondPrim.setTokenChecker(savedChk);
        return endLev;
    }

    protected static final class KtCondEntry {
        public static final KtCondEntry NULL = null;
        public final KtCondEntry next;
        public int limit;
        public final KtExpandable curr;
        public final KtFilePos fpos;

        KtCondEntry(KtCondEntry next, int limit, KtExpandable curr, KtFilePos fpos) {
            this.next = next;
            this.limit = limit;
            this.curr = curr;
            this.fpos = fpos;
        }
    }

    static class KtSkipToksChecker
    implements KtInpTokChecker {
        private final KtLoggable[] params;

        public KtSkipToksChecker(KtLoggable[] params) {
            this.params = params;
        }

        @Override
        public KtToken checkToken(KtToken tok, KtBoolPar canExpand) {
            if (KtCommandBase.meaningOf(tok, canExpand.get()).isOuter()) {
                KtCommandBase.backTokenWithoutCleaning(tok);
                this.reportError("OuterInSkipped");
                canExpand.set(true);
                return KtSpaceToken.TOKEN;
            }
            return tok;
        }

        @Override
        public void checkEndOfFile() {
            this.reportError("EOFinSkipped");
        }

        protected void reportError(String ident) {
            KtCommandBase.insertToken(KtCommandBase.getConfig().frozenFi());
            KtCommandBase.nonDelError(ident, this.params);
        }
    }
}

