/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtPrimitive;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtName;

public class KtFrozenToken
extends KtToken {
    private final KtName name;
    private final KtCommand cmd;

    public KtFrozenToken(KtName name, KtCommand cmd) {
        this.name = name;
        this.cmd = cmd;
    }

    public KtFrozenToken(String name, KtCommand cmd) {
        this.name = KtFrozenToken.makeName(name);
        this.cmd = cmd;
    }

    public KtFrozenToken(KtPrimitive prim) {
        this.name = KtFrozenToken.makeName(prim.getName());
        this.cmd = prim.getCommand();
    }

    @Override
    public KtCommand meaning() {
        return this.cmd;
    }

    @Override
    public boolean frozen() {
        return true;
    }

    @Override
    public boolean match(KtToken tok) {
        return false;
    }

    @Override
    public void addOn(KtLog log) {
        this.name.addEscapedOn(log);
    }

    @Override
    public void addProperlyOn(KtLog log) {
        this.name.addProperlyEscapedOn(log);
    }

    @Override
    public int numValue() {
        return this.name.length() == 1 ? this.name.codeAt(0).numValue() : -1;
    }

    @Override
    public KtName controlName() {
        return this.name;
    }

    public String toString() {
        return "<Frozen: " + String.valueOf(this.name) + ">";
    }
}

