/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.noad;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.noad.KtConvStyle;
import com.whitemagicsoftware.keentype.noad.KtConverter;
import com.whitemagicsoftware.keentype.noad.KtDelimiter;
import com.whitemagicsoftware.keentype.noad.KtEgg;
import com.whitemagicsoftware.keentype.noad.KtNoad;
import com.whitemagicsoftware.keentype.noad.KtNoadEnum;
import com.whitemagicsoftware.keentype.noad.KtNoadEnumStack;
import com.whitemagicsoftware.keentype.noad.KtNodery;
import com.whitemagicsoftware.keentype.noad.KtSimpleNodeEgg;
import com.whitemagicsoftware.keentype.noad.KtStItalNodeEgg;
import com.whitemagicsoftware.keentype.noad.KtTransfConstants;
import com.whitemagicsoftware.keentype.noad.KtTransformer;
import com.whitemagicsoftware.keentype.noad.KtVoidEgg;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtMathWordBuilder;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtPenaltyNode;
import com.whitemagicsoftware.keentype.node.KtTreatNode;
import java.util.Iterator;
import java.util.Vector;

public class KtConversion
implements KtTransfConstants {
    private final KtNoadEnumStack stack;
    private final KtConvStyle convStyle;

    protected KtConversion(KtNoadEnum noads, KtConvStyle convStyle) {
        this.stack = new KtNoadEnumStack(noads);
        this.convStyle = convStyle;
    }

    protected KtNodeList convert() {
        KtEgg egg;
        KtHen converter = new KtHen(this.convStyle);
        KtClutch clutch = new KtClutch(this);
        block0: while (this.stack.hasMoreNoads()) {
            boolean again;
            KtNoad noad = this.stack.nextNoad();
            block1: do {
                again = false;
                if (noad.startsWord()) {
                    KtMathWordBuilder word;
                    block10: {
                        word = noad.getMathWordBuilder(converter, clutch.appender());
                        if (word == KtMathWordBuilder.NULL) {
                            clutch.add(noad, noad.convert(converter));
                            continue block0;
                        }
                        byte fam = noad.wordFamily();
                        clutch.suppressingAllowed = !converter.forcedItalCorr(fam);
                        noad.contributeToWord(word);
                        do {
                            if (!this.stack.hasMoreNoads()) {
                                clutch.addOrd(word.takeLastNode(), false);
                                continue block1;
                            }
                            noad = this.stack.nextNoad();
                            if (!noad.canBePartOfWord() || noad.wordFamily() != fam) break block10;
                            noad.contributeToWord(word);
                        } while (!noad.finishesWord() || (egg = noad.wordFinishingEgg(word, converter)) == KtEgg.NULL);
                        clutch.add(noad, egg);
                        continue;
                    }
                    clutch.addOrd(word.takeLastNode(), false);
                    again = true;
                    continue;
                }
                clutch.add(noad, noad.convert(converter));
            } while (again);
        }
        clutch.finish();
        byte leftPenType = -1;
        byte leftSpacType = -1;
        KtCoop coop = new KtCoop(this, this.convStyle, clutch.maxHeight, clutch.maxDepth);
        Iterator iter = clutch.iterator();
        while (iter.hasNext()) {
            KtNum pen;
            egg = (KtEgg)iter.next();
            byte right = egg.spacingType();
            if (!egg.isPenalty() && (pen = coop.getConv().getPenalty(leftPenType, right)) != KtNum.NULL && pen.lessThan(10000)) {
                coop.append(new KtPenaltyNode(pen));
            }
            leftPenType = right;
            if (right != -1) {
                KtNode space;
                if (leftSpacType != -1 && (space = coop.getConv().getSpacing(leftSpacType, right)) != KtNode.NULL) {
                    coop.append(space);
                }
                leftSpacType = right;
            }
            egg.chipShell(coop);
            coop.setIgnoreSpace(egg.ignoreNextScriptSpace());
        }
        return coop.getList();
    }

    public static KtNodeList madeOf(KtNoadEnum noads, KtConvStyle conv) {
        return new KtConversion(noads, conv).convert();
    }

    protected class KtHen
    extends KtTransf
    implements KtConverter {
        public KtHen(KtConvStyle conv) {
            super(conv);
        }

        @Override
        public void push(KtNoadEnum noads) {
            KtConversion.this.stack.push(noads);
        }

        @Override
        public KtMathWordBuilder getWordBuilder(byte fam, KtTreatNode proc) {
            return this.conv.getWordBuilder(fam, proc);
        }

        public boolean forcedItalCorr(byte fam) {
            return this.conv.forcedItalCorr(fam);
        }
    }

    private class KtClutch {
        public KtDimen maxHeight = KtDimen.ZERO;
        public KtDimen maxDepth = KtDimen.ZERO;
        private final Vector<KtEgg> data = new Vector();
        private boolean prevCanPrecedeBin = false;
        private KtEgg lastInfluencing = KtVoidEgg.EGG;
        public boolean suppressingAllowed = true;

        private KtClutch(KtConversion ktConversion) {
        }

        public Iterator iterator() {
            return this.data.iterator();
        }

        public KtTreatNode appender() {
            return new KtTreatNode(){

                @Override
                public void execute(KtNode node) {
                    if (node.uniformMetric() != KtFontMetric.NULL) {
                        KtClutch.this.addOrd(node, true);
                    } else {
                        KtClutch.this.addEgg(new KtSimpleNodeEgg(node));
                    }
                }
            };
        }

        public void add(KtNoad noad, KtEgg egg) {
            if (noad.influencesBin()) {
                boolean forced;
                boolean bl = forced = egg.isBin() && !this.prevCanPrecedeBin;
                if (forced) {
                    egg.dontBeBin();
                    this.prevCanPrecedeBin = true;
                } else {
                    if (!noad.canFollowBin() && this.lastInfluencing.isBin()) {
                        this.lastInfluencing.dontBeBin();
                    }
                    this.prevCanPrecedeBin = noad.canPrecedeBin();
                }
                this.lastInfluencing = egg;
            }
            this.addEgg(egg);
        }

        public void addOrd(KtNode node, boolean suppress) {
            this.prevCanPrecedeBin = true;
            KtStItalNodeEgg egg = new KtStItalNodeEgg(node, 0);
            if (suppress && this.suppressingAllowed) {
                ((KtEgg)egg).suppressItalCorr();
            }
            this.lastInfluencing = egg;
            this.addEgg(egg);
        }

        private void addEgg(KtEgg egg) {
            this.maxHeight = this.maxHeight.max(egg.getHeight());
            this.maxDepth = this.maxDepth.max(egg.getDepth());
            this.data.add(egg);
        }

        public void finish() {
            if (this.lastInfluencing.isBin()) {
                this.lastInfluencing.dontBeBin();
            }
        }
    }

    protected class KtCoop
    extends KtTransf
    implements KtNodery {
        private final KtDimen height;
        private final KtDimen depth;
        private final KtNodeList list = new KtNodeList();
        private boolean ignore = false;

        public KtCoop(KtConversion this$0, KtConvStyle conv, KtDimen height, KtDimen depth) {
            super(conv);
            this.height = height;
            this.depth = depth;
        }

        public KtNodeList getList() {
            return this.list;
        }

        public void setIgnoreSpace(boolean ign) {
            this.ignore = ign;
        }

        @Override
        public boolean ignoresSpace() {
            return this.ignore && this.conv.isScript();
        }

        @Override
        public void append(KtNode node) {
            this.list.append(node);
        }

        @Override
        public void append(KtNodeEnum nodes) {
            this.list.append(nodes);
        }

        @Override
        public KtDimen delimiterSize() {
            KtDimen middle = this.getDimPar(16);
            return this.conv.delimiterSize(this.height.minus(middle), this.depth.plus(middle));
        }
    }

    protected class KtTransf
    implements KtTransformer {
        protected KtConvStyle conv;

        public KtTransf(KtConvStyle conv) {
            this.conv = conv;
        }

        public KtConvStyle getConv() {
            return this.conv;
        }

        @Override
        public void setStyle(byte style) {
            this.conv = this.conv.makeNew(style);
        }

        @Override
        public byte getStyle() {
            return this.conv.getStyle();
        }

        @Override
        public boolean isCramped() {
            return this.conv.isCramped();
        }

        @Override
        public KtDimen muToPt(KtDimen dim) {
            return this.conv.muToPt(dim);
        }

        @Override
        public KtGlue muToPt(KtGlue skip) {
            return this.conv.muToPt(skip);
        }

        @Override
        public KtDimen scriptSpace() {
            return this.conv.scriptSpace();
        }

        @Override
        public KtDimen getDimPar(int param) {
            return this.conv.getDimPar(param);
        }

        @Override
        public KtDimen getDimPar(int param, byte how) {
            return this.conv.derived(how).getDimPar(param);
        }

        @Override
        public KtNode fetchCharNode(byte fam, KtCharCode code) {
            return this.conv.fetchCharNode(fam, code);
        }

        @Override
        public KtNode fetchCharNode(byte fam, KtCharCode code, byte how) {
            return this.conv.derived(how).fetchCharNode(fam, code);
        }

        @Override
        public KtNode fetchLargerNode(byte fam, KtCharCode code) {
            return this.conv.fetchLargerNode(fam, code);
        }

        @Override
        public KtNode fetchSufficientNode(KtDelimiter del, KtDimen desired) {
            return KtConversion.this.convStyle.fetchSufficientNode(del, desired);
        }

        @Override
        public KtBox fetchFittingWidthBox(byte fam, KtCharCode code, KtDimen desired) {
            return this.conv.fetchFittingWidthBox(fam, code, desired);
        }

        @Override
        public KtDimen skewAmount(byte fam, KtCharCode code) {
            return this.conv.skewAmount(fam, code);
        }

        @Override
        public KtDimen getXHeight(byte fam) {
            return this.conv.getXHeight(fam);
        }

        @Override
        public KtNodeList convert(KtNoadEnum noads) {
            return KtConversion.madeOf(noads, this.conv.derived((byte)0));
        }

        @Override
        public KtNodeList convert(KtNoadEnum noads, byte how) {
            return KtConversion.madeOf(noads, this.conv.derived(how));
        }
    }
}

