/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.render;

import com.whitemagicsoftware.keentype.tex.KtFileFormat;
import com.whitemagicsoftware.keentype.tex.KtFileOpener;
import com.whitemagicsoftware.keentype.tex.KtFontInfo;
import com.whitemagicsoftware.keentype.tex.KtTeXCharMapper;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class KtFontReader {
    public static final Font DEFAULT_FONT = Font.decode(null);

    public Font createFont(KtFontInfo info) {
        String dirName = new String(info.getDirName());
        String fileName = new String(info.getFileName());
        Path path = Path.of(dirName, fileName);
        KtTeXCharMapper.KtTeXFileName filename = new KtTeXCharMapper.KtTeXFileName();
        filename.setPath(path.toString());
        Font font = this.createFont(filename);
        Map<TextAttribute, ?> attrs = font.getAttributes();
        attrs.put(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
        attrs.put(TextAttribute.SIZE, info.getAtSize().toInt());
        return font.deriveFont(attrs);
    }

    private Font createFont(KtTeXCharMapper.KtTeXFileName filename) {
        KtFileOpener opener = new KtFileOpener();
        AtomicReference<Font> font = new AtomicReference<Font>(DEFAULT_FONT);
        opener.attachHandler(KtFileFormat.PFB_EXT, is -> {
            font.set(Font.createFont(1, is));
            is.close();
        });
        opener.attachHandler(KtFileFormat.OTF_EXT, is -> {
            font.set(Font.createFont(0, is));
            is.close();
        });
        opener.attachHandler(KtFileFormat.TTF_EXT, is -> {
            font.set(Font.createFont(0, is));
            is.close();
        });
        try {
            opener.read(filename, KtFileFormat.PFB_EXT, KtFileFormat.OTF_EXT, KtFileFormat.TTF_EXT);
        }
        catch (FontFormatException e) {
            throw new UncheckedIOException(new IOException(e));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return font.get();
    }
}

