/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tex;

import com.whitemagicsoftware.keentype.align.KtTabMarkToken;
import com.whitemagicsoftware.keentype.command.KtActiveCharToken;
import com.whitemagicsoftware.keentype.command.KtCharToken;
import com.whitemagicsoftware.keentype.command.KtCtrlSeqToken;
import com.whitemagicsoftware.keentype.command.KtInputLineTokenizer;
import com.whitemagicsoftware.keentype.command.KtLeftBraceToken;
import com.whitemagicsoftware.keentype.command.KtLetterToken;
import com.whitemagicsoftware.keentype.command.KtMacroParamToken;
import com.whitemagicsoftware.keentype.command.KtOtherToken;
import com.whitemagicsoftware.keentype.command.KtRightBraceToken;
import com.whitemagicsoftware.keentype.command.KtSpaceToken;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.events.KtErrorEvent;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.io.KtName;
import com.whitemagicsoftware.keentype.math.KtMathShiftToken;
import com.whitemagicsoftware.keentype.math.KtSubMarkToken;
import com.whitemagicsoftware.keentype.math.KtSuperMarkToken;
import com.whitemagicsoftware.keentype.tex.KtTeXErrorPool;

public class KtTeXTokenMaker
implements KtInputLineTokenizer.KtTokenMaker {
    private final KtCategorizer categorizer;
    private final byte[] scanCats = new byte[16];
    private final KtCharToken.KtMaker[] charTokMakers = new KtCharToken.KtMaker[16];
    private static final KtToken PAR_TOKEN = new KtCtrlSeqToken("par");

    public KtTeXTokenMaker(KtCategorizer categ) {
        this.categorizer = categ;
        for (int i = 0; i <= 15; ++i) {
            this.scanCats[i] = 6;
            this.charTokMakers[i] = KtOtherToken.MAKER;
        }
        this.initScanCat(0, (byte)0);
        this.initScanCat(5, (byte)3);
        this.initScanCat(9, (byte)5);
        this.initScanCat(10, (byte)2);
        this.initScanCat(14, (byte)4);
        this.scanCats[11] = 1;
        this.charTokMakers[1] = KtLeftBraceToken.MAKER;
        this.charTokMakers[2] = KtRightBraceToken.MAKER;
        this.charTokMakers[3] = KtMathShiftToken.MAKER;
        this.charTokMakers[4] = KtTabMarkToken.MAKER;
        this.charTokMakers[6] = KtMacroParamToken.MAKER;
        this.charTokMakers[7] = KtSuperMarkToken.MAKER;
        this.charTokMakers[8] = KtSubMarkToken.MAKER;
        this.charTokMakers[11] = KtLetterToken.MAKER;
        this.charTokMakers[12] = KtOtherToken.MAKER;
        this.charTokMakers[13] = KtActiveCharToken.MAKER;
        this.charTokMakers[15] = code -> {
            KtErrorEvent.publish(KtTeXErrorPool.get("InvalidChar"));
            return KtToken.NULL;
        };
    }

    private void initScanCat(int idx, byte cat) {
        this.scanCats[idx] = cat;
        this.charTokMakers[idx] = null;
    }

    @Override
    public byte scanCat(KtCharCode code) {
        return this.scanCats[this.categorizer.catCode(code.toChar())];
    }

    @Override
    public KtToken make(KtName name) {
        return new KtCtrlSeqToken(name);
    }

    @Override
    public KtToken make(KtCharCode code) {
        KtCharToken.KtMaker maker = this.charTokMakers[this.categorizer.catCode(code.toChar())];
        if (maker != null) {
            return maker.make(code);
        }
        throw new RuntimeException("Invalid category for making a KtToken");
    }

    @Override
    public KtToken makeSpace() {
        return KtSpaceToken.TOKEN;
    }

    @Override
    public KtToken makePar() {
        return PAR_TOKEN;
    }

    public static interface KtCategorizer {
        public int catCode(int var1);
    }

    public static interface KtErrHandler {
        public void error(String var1, KtLoggable[] var2, boolean var3);

        public void fatalError(String var1);
    }
}

