/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.align;

import com.whitemagicsoftware.keentype.align.KtAlignGroup;
import com.whitemagicsoftware.keentype.align.KtAlignment;
import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.math.KtDisplayGroup;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;

public class KtDispAlignGroup
extends KtAlignGroup {
    public static final int INTP_PRE_DISPLAY_PENALTY = KtDisplayGroup.INTP_PRE_DISPLAY_PENALTY;
    public static final int INTP_POST_DISPLAY_PENALTY = KtDisplayGroup.INTP_POST_DISPLAY_PENALTY;
    public static final int DIMP_DISPLAY_INDENT = KtDisplayGroup.DIMP_DISPLAY_INDENT;
    public static final int GLUEP_ABOVE_DISPLAY_SKIP = KtDisplayGroup.GLUEP_ABOVE_DISPLAY_SKIP;
    public static final int GLUEP_BELOW_DISPLAY_SKIP = KtDisplayGroup.GLUEP_BELOW_DISPLAY_SKIP;

    public KtDispAlignGroup(KtAlignment align) {
        super(align);
    }

    @Override
    public void stop() {
        KtCommandBase.KtConfig cfg = KtDispAlignGroup.getConfig();
        KtDimen indent = cfg.getDimParam(DIMP_DISPLAY_INDENT);
        KtNodeEnum nodes = this.align.finish(indent);
        if (KtDispAlignGroup.expectMathShift()) {
            KtDisplayGroup.expectAnotherMathShift();
        }
        KtBuilder.pop();
        KtBuilder bld = KtBuilder.top();
        bld.addPenalty(KtNum.valueOf(cfg.getIntParam(INTP_PRE_DISPLAY_PENALTY)));
        bld.addSkip(cfg.getGlueParam(GLUEP_ABOVE_DISPLAY_SKIP), cfg.getGlueName(GLUEP_ABOVE_DISPLAY_SKIP));
        bld.addNodes(nodes);
        bld.addPenalty(KtNum.valueOf(cfg.getIntParam(INTP_POST_DISPLAY_PENALTY)));
        bld.addSkip(cfg.getGlueParam(GLUEP_BELOW_DISPLAY_SKIP), cfg.getGlueName(GLUEP_BELOW_DISPLAY_SKIP));
        this.align.copyPrevParameters(bld);
    }

    @Override
    public void close() {
        KtDispAlignGroup.killLevel();
        KtDisplayGroup.resumeAfterDisplay();
    }

    protected static boolean expectMathShift() {
        KtToken tok = KtDispAlignGroup.nextNonAssignment();
        if (!KtDispAlignGroup.meaningOf(tok).isMathShift()) {
            KtDispAlignGroup.backToken(tok);
            KtDispAlignGroup.error("MissingFormulaEnd");
            return false;
        }
        return true;
    }
}

