/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;

public abstract class KtCharToken
extends KtToken {
    protected KtCharCode code;

    public KtCharToken(KtCharCode code) {
        this.code = code;
    }

    @Override
    public final KtCharCode charCode() {
        return this.code;
    }

    @Override
    public KtToken makeCharToken(KtCharCode code) {
        KtMaker maker = this.getMaker();
        return maker != null ? maker.make(code) : KtToken.NULL;
    }

    @Override
    public KtCharCode nonActiveCharCode() {
        return this.code;
    }

    @Override
    public int numValue() {
        return this.code.numValue();
    }

    @Override
    public void addOn(KtLog log) {
        log.add(this.code);
    }

    @Override
    public final boolean match(KtToken tok) {
        return tok instanceof KtCharToken && this.match((KtCharToken)tok);
    }

    public final boolean match(KtCharCode chr) {
        return this.code.match(chr);
    }

    public abstract boolean match(KtCharToken var1);

    @Override
    public KtToken category() {
        return this;
    }

    public abstract KtMaker getMaker();

    public String toString() {
        return "<KtChar: " + String.valueOf(this.code) + ">";
    }

    public static interface KtMaker {
        public KtToken make(KtCharCode var1);
    }

    public abstract class KtMeaning
    extends KtCommand {
        @Override
        public final KtCharCode charCode() {
            return KtCharToken.this.code;
        }

        @Override
        public final void addOn(KtLog log) {
            log.add(this.description()).add(' ').add(KtCharToken.this.code);
        }

        @Override
        public boolean sameAs(KtCommand cmd) {
            return this.getClass() == cmd.getClass() && KtCharToken.this.code.match(cmd.charCode());
        }

        @Override
        public final KtToken origin() {
            return KtCharToken.this;
        }

        public final String toString() {
            return "[" + this.description() + " " + String.valueOf(KtCharToken.this.code) + "]";
        }

        protected abstract String description();
    }
}

