/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.base.KtBoolPar;
import com.whitemagicsoftware.keentype.base.KtBytePar;
import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtEqTable;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.base.KtIntPar;
import com.whitemagicsoftware.keentype.base.KtLevelEqTable;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.command.KtBottomGroup;
import com.whitemagicsoftware.keentype.command.KtBraceNesting;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtFileName;
import com.whitemagicsoftware.keentype.command.KtGroup;
import com.whitemagicsoftware.keentype.command.KtInpTokChecker;
import com.whitemagicsoftware.keentype.command.KtReadInput;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.command.KtTokenizerStack;
import com.whitemagicsoftware.keentype.command.KtUndefined;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtDoubleLineOutput;
import com.whitemagicsoftware.keentype.io.KtEofToken;
import com.whitemagicsoftware.keentype.io.KtEqTraceable;
import com.whitemagicsoftware.keentype.io.KtInputLine;
import com.whitemagicsoftware.keentype.io.KtLineInput;
import com.whitemagicsoftware.keentype.io.KtLineOutput;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.io.KtMaxLoggable;
import com.whitemagicsoftware.keentype.io.KtName;
import com.whitemagicsoftware.keentype.io.KtNullLog;
import java.io.Serializable;

public abstract class KtCommandBase {
    private static KtLevelEqTable eqTable;
    private static KtTokenizerStack tokStack;
    private static KtBraceNesting braceNesting;
    private static int MAX_INT_PARAM;
    private static int MAX_DIM_PARAM;
    private static int MAX_GLUE_PARAM;
    private static int MAX_TOKS_PARAM;
    private static final int MAX_NODE_PARAM = 0;
    private static int MAX_BOOL_PARAM;
    private static KtConfig config;
    private static KtIOHandler ioHandler;
    private static KtLineOutput terminal;
    private static KtLineOutput logFile;
    private static KtLineOutput termAndLog;
    public static KtLog termLog;
    public static KtLog fileLog;
    public static KtLog normLog;
    public static KtLog diagLog;
    private static boolean termEnable;
    private static boolean diagOnTerm;
    private static KtLineInput input;
    public static final int INTP_MAX_RUNAWAY_WIDTH;
    public static final int BOOLP_TRACING_TOKEN_LISTS;
    public static final int INTP_MAX_TLRES_TRACE;
    public static final int BOOLP_TRACING_RESTORES;
    public static final int RESTORING = 0;
    public static final int RETAINING = 1;
    private static final KtCurrGroup currGroup;
    protected static final int DIMEN_DENOMINATOR = 65536;
    public static final int DIMP_EM;
    public static final int DIMP_EX;
    private static final KtDimUnitDesc[] dimUnits;
    public static final int INTP_MAGNIFICATION;

    public static void setEqt(KtLevelEqTable eqtab) {
        eqTable = eqtab;
    }

    public static KtEqTable getEqt() {
        return eqTable;
    }

    /*
     * WARNING - void declaration
     */
    public static KtCommand meaningOf(KtToken tok) {
        void var1_1;
        KtCommand cmd;
        return tok == KtToken.NULL || (cmd = tok.meaning()) == KtCommand.NULL ? KtUndefined.getUndefined() : var1_1;
    }

    public static KtCommand meaningOf(KtToken tok, boolean expOK) {
        return KtCommandBase.meaningOf(tok).meaning(expOK);
    }

    public static void setTokStack(KtTokenizerStack tokstack) {
        tokStack = tokstack;
    }

    public static KtTokenizerStack getTokStack() {
        return tokStack;
    }

    public static KtInpTokChecker setTokenChecker(KtInpTokChecker chk) {
        return tokStack.setChecker(chk);
    }

    public static int currLineNumber() {
        return tokStack.lineNumber();
    }

    public static int braceNestingDifference(KtToken tok) {
        assert (tok != null);
        return tok.matchLeftBrace() ? 1 : (tok.matchRightBrace() ? -1 : 0);
    }

    public static KtToken nextRawToken(KtBoolPar canExpand) {
        KtToken tok;
        KtCommand cmd;
        while ((cmd = KtCommandBase.meaningOf(tok = tokStack.nextToken(canExpand))).explosive()) {
            cmd.detonate(tok);
            if (tok != KtToken.NULL) continue;
        }
        if (tok != KtToken.NULL) {
            KtCommandBase.adjustBraceNesting(KtCommandBase.braceNestingDifference(tok));
        }
        return tok;
    }

    public static KtToken nextRawToken() {
        return KtCommandBase.nextRawToken(KtBoolPar.NULL);
    }

    public static KtToken nextUncheckedRawToken(KtBoolPar canExpand) {
        KtInpTokChecker savedChk = KtCommandBase.setTokenChecker(KtInpTokChecker.NULL);
        KtToken tok = KtCommandBase.nextRawToken(canExpand);
        KtCommandBase.setTokenChecker(savedChk);
        return tok;
    }

    public static KtToken nextUncheckedRawToken() {
        return KtCommandBase.nextUncheckedRawToken(KtBoolPar.NULL);
    }

    public static void backToken(KtToken tok) {
        tokStack.cleanFinishedLists();
        KtCommandBase.backTokenWithoutCleaning(tok);
    }

    public static void backTokenWithoutCleaning(KtToken tok) {
        tokStack.backUp(tok, true);
        KtCommandBase.adjustBraceNesting(-KtCommandBase.braceNestingDifference(tok));
    }

    public static void backList(KtTokenList list) {
        tokStack.backUp(list);
    }

    public static void pushToken(KtToken tok, String desc) {
        tokStack.push(tok, "<" + desc + "> ");
    }

    public static void pushList(KtTokenList list, String desc) {
        tokStack.push(list, "<" + desc + "> ");
    }

    public static void insertToken(KtToken tok) {
        tokStack.cleanFinishedLists();
        tokStack.push(tok, "<inserted text> ");
    }

    public static void insertTokenWithoutCleaning(KtToken tok) {
        tokStack.push(tok, "<inserted text> ");
    }

    public static void insertList(KtTokenList list) {
        tokStack.push(list, "<inserted text> ");
    }

    public static KtToken nextExpToken() {
        KtToken tok;
        while ((tok = KtCommandBase.onlyRawToken()) == KtToken.NULL) {
        }
        return tok;
    }

    public static KtToken onlyRawToken() {
        KtBoolPar exp = new KtBoolPar();
        KtToken tok = KtCommandBase.nextRawToken(exp);
        KtCommand cmd = KtCommandBase.meaningOf(tok);
        if (cmd.expandable() && exp.get()) {
            cmd.doExpansion(tok);
            return KtToken.NULL;
        }
        return cmd instanceof KtUndefined ? new KtEofToken() : tok;
    }

    public static KtToken nextExpToken(KtTokenList.KtBuffer buf) {
        KtBoolPar exp = new KtBoolPar();
        KtToken tok = KtCommandBase.nextRawToken(exp);
        KtCommand cmd = KtCommandBase.meaningOf(tok);
        if (exp.get()) {
            if (cmd.appendToks(buf)) {
                return KtToken.NULL;
            }
            if (cmd.expandable()) {
                cmd.doExpansion(tok);
                return KtToken.NULL;
            }
        }
        return tok;
    }

    public static KtBraceNesting setBraceNesting(KtBraceNesting nesting) {
        KtBraceNesting old = braceNesting;
        braceNesting = nesting;
        return old;
    }

    public static void adjustBraceNesting(int count) {
        braceNesting.adjust(count);
    }

    public static int maxIntParam() {
        return MAX_INT_PARAM;
    }

    public static int maxDimParam() {
        return MAX_DIM_PARAM;
    }

    public static int maxGlueParam() {
        return MAX_GLUE_PARAM;
    }

    public static int maxToksParam() {
        return MAX_TOKS_PARAM;
    }

    public static int maxBoolParam() {
        return MAX_BOOL_PARAM;
    }

    protected static int newIntParam() {
        return MAX_INT_PARAM++;
    }

    protected static int newDimParam() {
        return MAX_DIM_PARAM++;
    }

    protected static int newGlueParam() {
        return MAX_GLUE_PARAM++;
    }

    protected static int newToksParam() {
        return MAX_TOKS_PARAM++;
    }

    protected static int newBoolParam() {
        return MAX_BOOL_PARAM++;
    }

    public static void setConfig(KtConfig conf) {
        config = conf;
    }

    public static KtConfig getConfig() {
        return config;
    }

    public static void setIOHandler(KtIOHandler ioHand) {
        ioHandler = ioHand;
    }

    public static KtIOHandler getIOHandler() {
        return ioHandler;
    }

    public static KtLog makeLog(KtLineOutput out) {
        return ioHandler.makeLog(out);
    }

    public static void ensureOpenLog() {
        ioHandler.ensureOpenLog();
    }

    public static void startInput() {
        ioHandler.openInput(KtCommandBase.scanFileName());
    }

    public static boolean isTermLogActive() {
        return termLog != KtNullLog.LOG;
    }

    public static boolean isFileLogActive() {
        return fileLog != KtNullLog.LOG;
    }

    public static boolean termDiagActive() {
        return diagOnTerm;
    }

    private static void setupLogs(KtLineOutput term, KtLineOutput file, boolean ten) {
        KtLineOutput both = termAndLog;
        if (term != terminal || file != logFile) {
            KtLineOutput ktLineOutput = term != KtLineOutput.NULL && file != KtLineOutput.NULL ? new KtDoubleLineOutput(term, file) : (both = term != KtLineOutput.NULL ? term : file);
        }
        if (ten != termEnable || term != terminal) {
            KtLog ktLog = termLog = ten && term != KtLineOutput.NULL ? KtCommandBase.makeLog(term) : KtNullLog.LOG;
        }
        if (file != logFile) {
            KtLog ktLog = fileLog = file != KtLineOutput.NULL ? KtCommandBase.makeLog(file) : KtNullLog.LOG;
        }
        if (ten != termEnable || both != termAndLog) {
            normLog = !ten ? fileLog : (both != KtLineOutput.NULL ? KtCommandBase.makeLog(both) : KtNullLog.LOG);
        }
        diagLog = diagOnTerm ? normLog : fileLog;
        terminal = term;
        logFile = file;
        termEnable = ten;
        termAndLog = both;
    }

    public static void setTermEnable(boolean ten) {
        if (ten != termEnable) {
            KtCommandBase.setupLogs(terminal, logFile, ten);
        }
    }

    public static void setDiagOnTerm(boolean dot) {
        diagOnTerm = dot;
        diagLog = diagOnTerm ? normLog : fileLog;
    }

    public static void setTerminal(KtLineOutput term) {
        KtCommandBase.setupLogs(term, logFile, termEnable);
    }

    public static void setLogFile(KtLineOutput file) {
        KtCommandBase.setupLogs(terminal, file, termEnable);
    }

    public static void setInput(KtLineInput in) {
        input = in;
    }

    public static KtInputLine promptInput(String prompt) {
        if (terminal != KtLineOutput.NULL) {
            termAndLog.add(prompt);
            terminal.flush();
            KtInputLine line = input.readLine();
            if (line != KtLineInput.EOF) {
                terminal.setStartLine();
                fileLog.add(line).endLine();
            } else {
                KtCommandBase.fatalError("EOFonTerm");
            }
            return line;
        }
        return KtLineInput.EOF;
    }

    public static KtLoggable num(final int n) {
        return new KtLoggable(){

            @Override
            public void addOn(KtLog log) {
                log.add(n);
            }
        };
    }

    public static KtLoggable str(final String s) {
        return new KtLoggable(){

            @Override
            public void addOn(KtLog log) {
                log.add(s);
            }
        };
    }

    public static KtLoggable str(final Object o) {
        return new KtLoggable(){

            @Override
            public void addOn(KtLog log) {
                log.add(o.toString());
            }
        };
    }

    public static KtLoggable esc(final String s) {
        return new KtLoggable(){

            @Override
            public void addOn(KtLog log) {
                log.addEsc(s);
            }
        };
    }

    public static KtLoggable esc(final KtName n) {
        return new KtLoggable(){

            @Override
            public void addOn(KtLog log) {
                n.addEscapedOn(log);
            }
        };
    }

    public static void error(String ident) {
        ioHandler.error(ident, null, true);
    }

    public static void error(String ident, KtLoggable p1) {
        KtLoggable[] params = new KtLoggable[]{p1};
        ioHandler.error(ident, params, true);
    }

    public static void error(String ident, KtLoggable p1, KtLoggable p2) {
        KtLoggable[] params = new KtLoggable[]{p1, p2};
        ioHandler.error(ident, params, true);
    }

    public static void error(String ident, KtLoggable p1, KtLoggable p2, KtLoggable p3) {
        KtLoggable[] params = new KtLoggable[]{p1, p2, p3};
        ioHandler.error(ident, params, true);
    }

    public static void error(String ident, KtLoggable p1, KtLoggable p2, KtLoggable p3, KtLoggable p4) {
        KtLoggable[] params = new KtLoggable[]{p1, p2, p3, p4};
        ioHandler.error(ident, params, true);
    }

    public static void error(String ident, KtLoggable[] params) {
        ioHandler.error(ident, params, true);
    }

    public static void nonDelError(String ident, KtLoggable[] params) {
        ioHandler.error(ident, params, false);
    }

    public static void fatalError(String ident) {
        ioHandler.fatalError(ident);
    }

    public static void errMessage(KtTokenList message) {
        ioHandler.errMessage(message);
    }

    public static void completeShow() {
        ioHandler.completeShow();
    }

    public static void illegalCommand(KtCommand cmd) {
        ioHandler.illegalCommand(cmd);
    }

    public static void runAway(String desc, KtMaxLoggable list) {
        normLog.startLine().add("Runaway ").add(desc).add('?').endLine();
        list.addOn(normLog, KtCommandBase.getConfig().getIntParam(INTP_MAX_RUNAWAY_WIDTH));
    }

    public static void traceCommand(KtCommand cmd) {
        diagLog.startLine().add('{');
        ioHandler.logMode();
        cmd.addOn(diagLog);
        diagLog.add('}').startLine();
    }

    public static void traceExpandable(KtCommand cmd) {
        diagLog.startLine().add('{');
        ioHandler.logMode();
        cmd.addExpandable(diagLog);
        diagLog.add('}').startLine();
    }

    public static void tracedPushXList(KtTokenList list, String desc) {
        if (KtCommandBase.getConfig().getBoolParam(BOOLP_TRACING_TOKEN_LISTS)) {
            diagLog.startLine().addEsc(desc).add("->").add(list).startLine();
        }
        KtCommandBase.pushList(list, desc);
    }

    public static void tracedPushList(KtTokenList list, String desc) {
        if (!list.isEmpty()) {
            KtCommandBase.tracedPushXList(list, desc);
        }
    }

    public static void traceRestore(int action, KtEqTraceable eqt) {
        if (KtCommandBase.getConfig().getBoolParam(BOOLP_TRACING_RESTORES)) {
            String s = switch (action) {
                case 0 -> "restoring";
                case 1 -> "retaining";
                default -> throw new RuntimeException("invalid action for traceRestore (" + action + ")");
            };
            diagLog.add('{').add(s).add(' ');
            eqt.addEqDescOn(diagLog);
            diagLog.add('=');
            eqt.addEqValueOn(diagLog);
            diagLog.add('}').startLine();
        }
    }

    public static KtGroup getGrp() {
        return currGroup.get();
    }

    public static void pushLevel(KtGroup grp) {
        currGroup.push(grp);
    }

    public static void popLevel() {
        currGroup.pop();
    }

    public static void killLevel() {
        currGroup.kill();
    }

    public static void finishGroups() {
        if (eqTable.getLevel() > 0) {
            normLog.startLine().add('(').addEsc("end").add(" occurred inside a group at level ").add(eqTable.getLevel()).add(')');
        }
    }

    protected static KtTokenList theToks() {
        String s;
        KtToken tok = KtCommandBase.nextExpToken();
        KtCommand cmd = KtCommandBase.meaningOf(tok);
        if (cmd.hasToksValue()) {
            return cmd.getToksValue();
        }
        if (cmd.hasFontTokenValue()) {
            KtCommandBase.backToken(tok);
            KtCommandBase.nextRawToken();
            return new KtTokenList(cmd.getFontTokenValue());
        }
        if (cmd.hasCrazyValue()) {
            s = "0";
        } else if (cmd.hasMuGlueValue()) {
            s = cmd.getMuGlueValue().toString("mu");
        } else if (cmd.hasGlueValue()) {
            s = cmd.getGlueValue().toString("pt");
        } else if (cmd.hasMuDimenValue()) {
            s = cmd.getMuDimenValue().toString("mu");
        } else if (cmd.hasDimenValue()) {
            s = cmd.getDimenValue().toString("pt");
        } else if (cmd.hasNumValue()) {
            s = cmd.getNumValue().toString();
        } else {
            s = "0";
            KtCommandBase.error("CantAfterThe", cmd, KtCommandBase.esc("the"));
        }
        return new KtTokenList(s);
    }

    public static int scanInt() {
        return KtCommandBase.scanInt(KtIntPar.NULL);
    }

    public static KtNum scanNum() {
        return KtNum.valueOf(KtCommandBase.scanInt(KtIntPar.NULL));
    }

    public static KtDimen scanDimen() {
        return KtCommandBase.scanDimen(false, KtBytePar.NULL);
    }

    public static KtDimen scanMuDimen() {
        return KtCommandBase.scanDimen(true, KtBytePar.NULL);
    }

    public static KtGlue scanGlue() {
        return KtCommandBase.scanGlue(false);
    }

    public static KtGlue scanMuGlue() {
        return KtCommandBase.scanGlue(true);
    }

    protected static int scanInt(KtIntPar radix) {
        int rdx = 0;
        long val = 0L;
        KtBoolPar negative = new KtBoolPar(false);
        KtToken tok = KtCommandBase.scanSign(negative);
        if (tok.matchOther('`')) {
            tok = KtCommandBase.nextRawToken();
            val = tok.numValue();
            if (val < 0L) {
                val = 48L;
                KtCommandBase.backToken(tok);
                KtCommandBase.error("NonNumericToken");
            } else {
                KtCommandBase.adjustBraceNesting(-KtCommandBase.braceNestingDifference(tok));
                KtCommandBase.skipOptExpSpacer();
            }
        } else {
            KtCommand cmd = KtCommandBase.meaningOf(tok);
            if (cmd.hasNumValue()) {
                val = cmd.getNumValue().intVal();
            } else {
                if (tok.matchOther('\'')) {
                    rdx = 8;
                    tok = KtCommandBase.nextExpToken();
                } else if (tok.matchOther('\"')) {
                    rdx = 16;
                    tok = KtCommandBase.nextExpToken();
                } else {
                    rdx = 10;
                }
                boolean empty = true;
                boolean ok = true;
                while (true) {
                    int digit = -1;
                    char dig = tok.otherChar();
                    if (dig != '\uffff') {
                        if (rdx > 10 && dig >= 'A') {
                            digit = dig - 65 + 10;
                        } else if (dig >= '0' && dig <= '9') {
                            digit = dig - 48;
                        }
                    } else if (rdx > 10 && (dig = tok.letterChar()) != '\uffff' && dig >= 'A') {
                        digit = dig - 65 + 10;
                    }
                    if (digit < 0 || digit >= rdx) break;
                    if (ok) {
                        empty = false;
                        if ((val = val * (long)rdx + (long)digit) > Integer.MAX_VALUE) {
                            ok = false;
                            KtCommandBase.error("NumberTooBig");
                            val = Integer.MAX_VALUE;
                        }
                    }
                    tok = KtCommandBase.nextExpToken();
                }
                if (empty) {
                    KtCommandBase.backToken(tok);
                    KtCommandBase.error("MissingNumber");
                } else {
                    KtCommandBase.skipOptSpacer(tok);
                }
            }
        }
        KtIntPar.set(radix, rdx);
        return negative.get() ? -((int)val) : (int)val;
    }

    protected static KtDimen scanDimen(boolean mu, KtBytePar glueOrder) {
        int n;
        KtDimen val = KtDimen.NULL;
        KtBytePar.set(glueOrder, (byte)0);
        KtBoolPar negative = new KtBoolPar(false);
        KtToken tok = KtCommandBase.scanSign(negative);
        KtCommand cmd = KtCommandBase.meaningOf(tok);
        if (mu) {
            if (cmd.hasMuDimenValue()) {
                val = cmd.getMuDimenValue();
            } else if (cmd.hasDimenValue()) {
                n = cmd.getDimenValue().toInt(65536);
                KtCommandBase.muError();
                val = KtCommandBase.convToDimenUnit(n, KtDimen.ZERO, mu, glueOrder);
            } else if (KtCommandBase.hasOtherValue(cmd)) {
                KtCommandBase.backToken(tok);
                KtCommandBase.error("MissingNumber");
                KtCommandBase.muError();
                val = KtCommandBase.convToDimenUnit(0, KtDimen.ZERO, mu, glueOrder);
            }
        } else if (cmd.hasDimenValue()) {
            val = cmd.getDimenValue();
        } else if (cmd.hasMuDimenValue()) {
            val = cmd.getMuDimenValue();
            KtCommandBase.muError();
        } else if (KtCommandBase.hasOtherValue(cmd)) {
            val = KtDimen.ZERO;
            KtCommandBase.backToken(tok);
            KtCommandBase.error("MissingNumber");
        }
        if (val == KtDimen.NULL) {
            if (cmd.hasNumValue()) {
                n = cmd.getNumValue().intVal();
                if (n < 0) {
                    negative.negate();
                    n = -n;
                }
                val = KtCommandBase.convToDimenUnit(n, KtDimen.ZERO, mu, glueOrder);
            } else {
                KtIntPar radix = new KtIntPar(10);
                boolean point = KtCommandBase.isPoint(tok);
                int whole = 0;
                KtDimen fract = KtDimen.ZERO;
                if (!point) {
                    KtCommandBase.backToken(tok);
                    whole = KtCommandBase.scanInt(radix);
                    tok = KtCommandBase.nextExpToken();
                    point = KtCommandBase.isPoint(tok);
                }
                if (point && radix.get() == 10) {
                    char dig;
                    StringBuilder buf = new StringBuilder();
                    buf.append('0').append('.');
                    while ((dig = (tok = KtCommandBase.nextExpToken()).otherChar()) != '\uffff' && dig >= '0' && dig <= '9') {
                        buf.append(dig);
                    }
                    try {
                        fract = KtDimen.valueOf(buf.toString());
                    }
                    catch (NumberFormatException e) {
                        whole = Integer.MIN_VALUE;
                    }
                }
                KtCommandBase.skipOptSpacer(tok);
                val = KtCommandBase.convToDimenUnit(whole, fract, mu, glueOrder);
            }
        }
        val = KtCommandBase.checkDimen(val);
        return negative.get() ? val.negative() : val;
    }

    private static KtDimen convToDimenUnit(int whole, KtDimen fract, boolean mu, KtBytePar glueOrder) {
        if (glueOrder != KtBytePar.NULL) {
            glueOrder.set(KtCommandBase.scanGlueOrderUnit());
            if (glueOrder.get() != 0) {
                return fract.plus(whole);
            }
        }
        return KtCommandBase.convToDimenUnit(whole, fract, mu);
    }

    private static byte scanGlueOrderUnit() {
        if (KtCommandBase.scanKeyword("fil")) {
            byte glord = 1;
            while (KtCommandBase.scanKeyword("l")) {
                if (glord < 3) {
                    glord = (byte)(glord + 1);
                    continue;
                }
                KtCommandBase.error("IllegalFil");
            }
            KtCommandBase.skipOptExpSpacer();
            return glord;
        }
        return 0;
    }

    private static KtDimen convToDimenUnit(int whole, KtDimen fract, boolean mu) {
        KtDimen val = KtDimen.NULL;
        KtToken tok = KtCommandBase.nextExpNonSpacer();
        KtCommand cmd = KtCommandBase.meaningOf(tok);
        if (mu) {
            if (cmd.hasMuDimenValue()) {
                val = cmd.getMuDimenValue();
            } else if (cmd.hasDimenValue()) {
                val = cmd.getDimenValue();
                KtCommandBase.muError();
            } else if (KtCommandBase.hasOtherValue(cmd)) {
                KtCommandBase.backToken(tok);
                KtCommandBase.error("MissingNumber");
                val = KtDimen.ZERO;
                KtCommandBase.muError();
            } else if (cmd.hasNumValue()) {
                val = KtDimen.valueOf(cmd.getNumValue().intVal(), 65536);
                KtCommandBase.muError();
            }
        } else if (cmd.hasDimenValue()) {
            val = cmd.getDimenValue();
        } else if (cmd.hasMuDimenValue()) {
            val = cmd.getMuDimenValue();
            KtCommandBase.muError();
        } else if (KtCommandBase.hasOtherValue(cmd)) {
            val = KtDimen.ZERO;
            KtCommandBase.backToken(tok);
            KtCommandBase.error("MissingNumber");
        } else if (cmd.hasNumValue()) {
            val = KtDimen.valueOf(cmd.getNumValue().intVal(), 65536);
        }
        if (val == KtDimen.NULL) {
            KtCommandBase.backToken(tok);
            if (mu) {
                if (!KtCommandBase.scanKeyword("mu")) {
                    KtCommandBase.error("IllegalMu");
                }
                KtCommandBase.skipOptExpSpacer();
                return fract.plus(whole);
            }
            if (KtCommandBase.scanKeyword("em")) {
                val = KtCommandBase.getConfig().getDimParam(DIMP_EM);
            } else if (KtCommandBase.scanKeyword("ex")) {
                val = KtCommandBase.getConfig().getDimParam(DIMP_EX);
            } else {
                val = KtCommandBase.convToDimenUnit(whole, fract);
                KtCommandBase.skipOptExpSpacer();
                return val;
            }
            KtCommandBase.skipOptExpSpacer();
        }
        return val.times(whole).plus(val.times(fract));
    }

    public static KtDimen makeDimen(int dim, String unit) {
        for (KtDimUnitDesc dimUnit : dimUnits) {
            if (!dimUnit.id.equals(unit)) continue;
            int num = dimUnit.num;
            int den = dimUnit.den;
            return den != 0 ? KtDimen.valueOf(dim).times(num, den) : KtDimen.shiftedValueOf(dim, num);
        }
        throw new RuntimeException("Illegal unit of measure (" + unit + ")");
    }

    private static KtDimen convToDimenUnit(int whole, KtDimen fract) {
        if (KtCommandBase.scanKeyword("true")) {
            int mag = KtCommandBase.getConfig().getIntParam(INTP_MAGNIFICATION);
            long w = (long)whole * 1000L;
            fract = fract.times(1000).plus((int)(w % (long)mag)).over(mag);
            int i = fract.toInt();
            whole = (int)(w / (long)mag) + i;
            fract = fract.minus(i);
        }
        for (KtDimUnitDesc dimUnit : dimUnits) {
            if (!KtCommandBase.scanKeyword(dimUnit.id)) continue;
            int num = dimUnit.num;
            int den = dimUnit.den;
            return den != 0 ? fract.plus(whole).times(num, den) : KtDimen.shiftedValueOf(whole, num).plus(fract.shifted(num));
        }
        KtCommandBase.error("IllegalUnit");
        return fract.plus(whole);
    }

    protected static void muError() {
        KtCommandBase.error("MixedGlueUnits");
    }

    private static KtDimen checkDimen(KtDimen val) {
        if (val.moreThan(KtDimen.MAX_VALUE)) {
            val = KtDimen.MAX_VALUE;
            KtCommandBase.error("DimenTooLarge");
        }
        return val;
    }

    protected static KtGlue scanGlue(boolean mu) {
        KtGlue val = KtGlue.NULL;
        KtDimen width = KtDimen.NULL;
        KtDimen plus = KtDimen.ZERO;
        KtDimen minus = KtDimen.ZERO;
        KtBytePar plusOrder = new KtBytePar(0);
        KtBytePar minusOrder = new KtBytePar(0);
        KtBoolPar negative = new KtBoolPar(false);
        KtToken tok = KtCommandBase.scanSign(negative);
        KtCommand cmd = KtCommandBase.meaningOf(tok);
        if (mu) {
            if (cmd.hasMuGlueValue()) {
                val = cmd.getMuGlueValue();
            } else if (cmd.hasGlueValue()) {
                val = cmd.getGlueValue();
                KtCommandBase.muError();
            } else if (cmd.hasMuDimenValue()) {
                width = cmd.getMuDimenValue();
            } else if (cmd.hasDimenValue()) {
                width = cmd.getDimenValue();
                KtCommandBase.muError();
            } else if (KtCommandBase.hasOtherValue(cmd)) {
                KtCommandBase.backToken(tok);
                KtCommandBase.error("MissingNumber");
                width = KtDimen.ZERO;
                KtCommandBase.muError();
            }
        } else if (cmd.hasGlueValue()) {
            val = cmd.getGlueValue();
        } else if (cmd.hasMuGlueValue()) {
            val = cmd.getMuGlueValue();
            KtCommandBase.muError();
        } else if (cmd.hasDimenValue()) {
            width = cmd.getDimenValue();
        } else if (cmd.hasMuDimenValue()) {
            width = cmd.getMuDimenValue();
            KtCommandBase.muError();
        } else if (KtCommandBase.hasOtherValue(cmd)) {
            width = KtDimen.ZERO;
            KtCommandBase.backToken(tok);
            KtCommandBase.error("MissingNumber");
        }
        if (val != KtGlue.NULL) {
            return negative.get() ? val.negative() : val;
        }
        if (width == KtDimen.NULL) {
            if (cmd.hasNumValue()) {
                int n = cmd.getNumValue().intVal();
                if (n < 0) {
                    negative.negate();
                    n = -n;
                }
                width = KtCommandBase.convToDimenUnit(n, KtDimen.ZERO, mu);
                width = KtCommandBase.checkDimen(width);
            } else {
                KtCommandBase.backToken(tok);
                width = KtCommandBase.scanDimen(mu, KtBytePar.NULL);
            }
        }
        if (negative.get()) {
            width = width.negative();
        }
        if (KtCommandBase.scanKeyword("plus")) {
            plus = KtCommandBase.scanDimen(mu, plusOrder);
        }
        if (KtCommandBase.scanKeyword("minus")) {
            minus = KtCommandBase.scanDimen(mu, minusOrder);
        }
        return KtGlue.valueOf(width, plus, plusOrder.get(), minus, minusOrder.get());
    }

    private static boolean isPoint(KtToken tok) {
        return tok.matchOther('.') || tok.matchOther(',');
    }

    private static boolean hasOtherValue(KtCommand cmd) {
        return cmd.hasToksValue() || cmd.hasFontTokenValue();
    }

    protected static KtToken scanSign(KtBoolPar negative) {
        KtToken tok;
        while (true) {
            if ((tok = KtCommandBase.nextExpNonSpacer()).matchOther('-')) {
                negative.set(!negative.get());
                continue;
            }
            if (!tok.matchOther('+')) break;
        }
        return tok;
    }

    protected static void skipOptSpacer(KtToken tok) {
        if (!KtCommandBase.meaningOf(tok).isSpacer()) {
            KtCommandBase.backToken(tok);
        }
    }

    protected static void skipOptExpSpacer() {
        KtCommandBase.skipOptSpacer(KtCommandBase.nextExpToken());
    }

    protected static KtToken nextExpNonSpacer() {
        KtToken tok;
        while (KtCommandBase.meaningOf(tok = KtCommandBase.nextExpToken()).isSpacer()) {
        }
        return tok;
    }

    public static void skipOptEquals() {
        KtToken tok = KtCommandBase.nextExpNonSpacer();
        if (!tok.matchOther('=')) {
            KtCommandBase.backToken(tok);
        }
    }

    protected static KtToken nextNonRelax() {
        KtToken tok;
        KtCommand cmd;
        while ((cmd = KtCommandBase.meaningOf(tok = KtCommandBase.nextExpToken())).isSpacer() || cmd.isRelax()) {
        }
        return tok;
    }

    protected static KtToken nextNonAssignment() {
        KtToken tok;
        KtCommand cmd;
        while ((cmd = KtCommandBase.meaningOf(tok = KtCommandBase.nextNonRelax())).assignable()) {
            cmd.doAssignment(tok, 0);
        }
        return tok;
    }

    public static void scanLeftBrace() {
        KtToken tok = KtCommandBase.nextNonRelax();
        if (!KtCommandBase.meaningOf(tok).isLeftBrace()) {
            KtCommandBase.backToken(tok);
            KtCommandBase.error("MissingLeftBrace");
            KtCommandBase.adjustBraceNesting(1);
        }
    }

    protected static boolean scanKeyword(String keyword) {
        KtToken[] backup = new KtToken[keyword.length()];
        KtToken tok = KtCommandBase.nextExpNonSpacer();
        int i = 0;
        while (true) {
            KtCharCode code;
            if ((code = tok.nonActiveCharCode()) == KtCharCode.NULL || !code.match(keyword.charAt(i)) && !code.match(Character.toUpperCase(keyword.charAt(i)))) {
                KtCommandBase.backToken(tok);
                if (i > 0) {
                    KtCommandBase.backList(new KtTokenList(backup, 0, i));
                }
                return false;
            }
            backup[i++] = tok;
            if (i >= keyword.length()) {
                return true;
            }
            tok = KtCommandBase.nextExpToken();
        }
    }

    protected static KtFileName scanFileName() {
        int i;
        KtToken tok;
        KtCommand cmd;
        boolean inpEnbl = KtCommandBase.getConfig().enableInput(false);
        KtFileName name = ioHandler.makeFileName();
        while ((cmd = KtCommandBase.meaningOf(tok = KtCommandBase.nextExpToken())).isSpacer()) {
        }
        while (true) {
            KtCharCode code;
            int n = i = (code = cmd.charCode()) != KtCharCode.NULL ? name.accept(code) : -1;
            if (i <= 0) break;
            tok = KtCommandBase.nextExpToken();
            cmd = KtCommandBase.meaningOf(tok);
        }
        if (i < 0) {
            KtCommandBase.backToken(tok);
        }
        KtCommandBase.getConfig().enableInput(inpEnbl);
        return name;
    }

    static {
        braceNesting = count -> {};
        MAX_INT_PARAM = 0;
        MAX_DIM_PARAM = 0;
        MAX_GLUE_PARAM = 0;
        MAX_TOKS_PARAM = 0;
        MAX_BOOL_PARAM = 0;
        terminal = KtLineOutput.NULL;
        logFile = KtLineOutput.NULL;
        termAndLog = KtLineOutput.NULL;
        termLog = KtNullLog.LOG;
        fileLog = KtNullLog.LOG;
        normLog = KtNullLog.LOG;
        diagLog = KtNullLog.LOG;
        termEnable = false;
        diagOnTerm = false;
        INTP_MAX_RUNAWAY_WIDTH = KtCommandBase.newIntParam();
        BOOLP_TRACING_TOKEN_LISTS = KtCommandBase.newBoolParam();
        INTP_MAX_TLRES_TRACE = KtCommandBase.newIntParam();
        BOOLP_TRACING_RESTORES = KtCommandBase.newBoolParam();
        currGroup = new KtCurrGroup();
        DIMP_EM = KtCommandBase.newDimParam();
        DIMP_EX = KtCommandBase.newDimParam();
        dimUnits = new KtDimUnitDesc[]{new KtDimUnitDesc("pt", 0), new KtDimUnitDesc("in", 7227, 100), new KtDimUnitDesc("pc", 12, 1), new KtDimUnitDesc("cm", 7227, 254), new KtDimUnitDesc("mm", 7227, 2540), new KtDimUnitDesc("bp", 7227, 7200), new KtDimUnitDesc("dd", 1238, 1157), new KtDimUnitDesc("cc", 14856, 1157), new KtDimUnitDesc("sp", -16)};
        INTP_MAGNIFICATION = KtCommandBase.newIntParam();
    }

    public static interface KtConfig {
        public int getIntParam(int var1);

        public KtDimen getDimParam(int var1);

        public KtGlue getGlueParam(int var1);

        public KtTokenList getToksParam(int var1);

        public boolean getBoolParam(int var1);

        public String getGlueName(int var1);

        public KtTokenList.KtInserter getToksInserter(int var1);

        public boolean enableInput(boolean var1);

        public boolean enableAfterAssignment(boolean var1);

        public void afterAssignment();

        public boolean formatLoaded();

        public KtToken frozenFi();
    }

    public static interface KtIOHandler {
        public KtName getJobName();

        public void ensureOpenLog();

        public void openInput(KtFileName var1);

        public KtReadInput openRead(KtFileName var1, int var2);

        public KtReadInput defaultRead(int var1);

        public KtLog makeLog(KtLineOutput var1);

        public KtLog makeStringLog();

        public KtLog openWrite(KtFileName var1, int var2);

        public KtFileName makeFileName();

        public void resetErrorCount();

        public void error(String var1, KtLoggable[] var2, boolean var3);

        public void fatalError(String var1);

        public void errMessage(KtTokenList var1);

        public void logMode();

        public void completeShow();

        public void illegalCommand(KtCommand var1);
    }

    private static class KtCurrGroup
    implements KtEqTable.KtExtEquiv {
        private int eqLevel = 0;
        private KtGroup group = new KtBottomGroup();

        private KtCurrGroup() {
        }

        @Override
        public final int getEqLevel() {
            return this.eqLevel;
        }

        @Override
        public final void setEqLevel(int lev) {
            this.eqLevel = lev;
        }

        public final KtGroup get() {
            return this.group;
        }

        public void push(KtGroup grp) {
            grp.open();
            eqTable.pushLevel();
            eqTable.save(this);
            grp.start();
            this.group = grp;
        }

        public void pop() {
            KtGroup grp = this.group;
            grp.stop();
            eqTable.popLevel();
            grp.close();
        }

        public void kill() {
            eqTable.popLevel();
        }

        @Override
        public final Object getEqValue() {
            return this.group;
        }

        @Override
        public final void retainEqValue() {
        }

        @Override
        public final void restoreEqValue(Object val) {
            this.group.unsaveAfter();
            this.group = (KtGroup)val;
        }
    }

    private static class KtDimUnitDesc {
        String id;
        int num;
        int den;

        KtDimUnitDesc(String i, int n, int d) {
            this.id = i;
            this.num = n;
            this.den = d;
        }

        KtDimUnitDesc(String i, int n) {
            this.id = i;
            this.num = n;
            this.den = 0;
        }
    }

    public static abstract class KtExtEquiv
    implements KtEqTable.KtExtEquiv,
    KtEqTraceable {
        private int eqLevel = 0;

        @Override
        public final int getEqLevel() {
            return this.eqLevel;
        }

        @Override
        public final void setEqLevel(int lev) {
            this.eqLevel = lev;
        }

        @Override
        public final void retainEqValue() {
            KtCommandBase.traceRestore(1, this);
        }

        @Override
        public final void restoreEqValue(Object val) {
            this.setEqValue(val);
            KtCommandBase.traceRestore(0, this);
        }

        protected final void beforeSetting(boolean glob) {
            KtCommandBase.getEqt().beforeSetting(this, glob);
        }

        @Override
        public abstract Object getEqValue();

        public abstract void setEqValue(Object var1);

        @Override
        public abstract void addEqDescOn(KtLog var1);

        @Override
        public abstract void addEqValueOn(KtLog var1);
    }

    public static abstract class KtTokKind
    extends KtEqTable.KtObjKind
    implements Serializable {
        @Override
        public final void restored(Object key, Object oldVal) {
            this.trace("restoring", key);
        }

        @Override
        public final void retained(Object key) {
            this.trace("retaining", key);
        }

        private void trace(String action, Object key) {
            if (KtCommandBase.getConfig().getBoolParam(BOOLP_TRACING_RESTORES)) {
                KtToken tok = this.getToken(key);
                diagLog.add('{').add(action).add(' ');
                diagLog.add(tok).add('=');
                KtCommandBase.meaningOf(tok).addExpandable(diagLog, KtCommandBase.getConfig().getIntParam(INTP_MAX_TLRES_TRACE));
                diagLog.add('}').startLine();
            }
        }

        protected abstract KtToken getToken(Object var1);
    }

    public static abstract class KtNumKind
    extends KtEqTable.KtNumKind
    implements Serializable {
        @Override
        public final void restored(int key, Object oldVal) {
            this.trace("restoring", key);
        }

        @Override
        public final void retained(int key) {
            this.trace("retaining", key);
        }

        private void trace(String action, int key) {
            if (KtCommandBase.getConfig().getBoolParam(BOOLP_TRACING_RESTORES)) {
                diagLog.add('{').add(action).add(' ');
                this.addDescOn(key, diagLog);
                diagLog.add('=');
                this.addValueOn(key, diagLog);
                diagLog.add('}').startLine();
            }
        }

        protected abstract void addDescOn(int var1, KtLog var2);

        protected abstract void addValueOn(int var1, KtLog var2);
    }
}

