/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtPrim;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtName;

public abstract class KtPrefixPrim
extends KtPrim {
    public static final int LONG = 1;
    public static final int OUTER = 2;
    public static final int GLOBAL = 4;
    private static final KtToken INACCESSIBLE = new KtToken(){
        private final KtName NAME = 1.makeName("inaccessible");

        @Override
        public boolean definable() {
            return true;
        }

        @Override
        public void define(KtCommand cmd, boolean glob) {
        }

        @Override
        public boolean match(KtToken tok) {
            return false;
        }

        @Override
        public void addOn(KtLog log) {
            this.NAME.addEscapedOn(log);
        }

        @Override
        public void addProperlyOn(KtLog log) {
            this.NAME.addProperlyEscapedOn(log);
        }
    };
    public static final int BOOLP_ALWAYS_GLOBAL = KtPrefixPrim.newBoolParam();
    public static final int BOOLP_NEVER_GLOBAL = KtPrefixPrim.newBoolParam();

    protected KtPrefixPrim(String name) {
        super(name);
    }

    @Override
    public final void exec(KtToken src) {
        this.exec(src, 0);
    }

    @Override
    public abstract void exec(KtToken var1, int var2);

    @Override
    public final boolean assignable() {
        return true;
    }

    @Override
    public void doAssignment(KtToken src, int prefixes) {
        this.exec(src, prefixes);
    }

    public static KtToken definableToken() {
        while (true) {
            KtToken tok;
            if ((tok = KtPrefixPrim.nextRawToken()).matchSpace()) {
                continue;
            }
            if (tok.definable()) {
                return tok;
            }
            if (!tok.frozen()) {
                KtPrefixPrim.backToken(tok);
            }
            KtPrefixPrim.insertToken(INACCESSIBLE);
            KtPrefixPrim.error("MissingCtrlSeq");
        }
    }

    public static boolean globalAssignment(int prefixes) {
        return KtPrefixPrim.getConfig().getBoolParam(BOOLP_ALWAYS_GLOBAL) || !KtPrefixPrim.getConfig().getBoolParam(BOOLP_NEVER_GLOBAL) && (prefixes & 4) != 0;
    }

    public static void beforeAssignment(KtCommand cmd, int prefixes) {
        if ((prefixes & 3) != 0) {
            KtPrefixPrim.error("NonDefineCommand", KtPrefixPrim.esc("long"), KtPrefixPrim.esc("outer"), cmd);
        }
    }

    public static void afterAssignment() {
        KtPrefixPrim.getConfig().afterAssignment();
    }
}

