/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.base.KtBoolPar;
import com.whitemagicsoftware.keentype.command.KtAssignPrim;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtContextDisplay;
import com.whitemagicsoftware.keentype.command.KtFrozenToken;
import com.whitemagicsoftware.keentype.command.KtInpTokChecker;
import com.whitemagicsoftware.keentype.command.KtMacro;
import com.whitemagicsoftware.keentype.command.KtMacroBody;
import com.whitemagicsoftware.keentype.command.KtReadInput;
import com.whitemagicsoftware.keentype.command.KtScanToksChecker;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenizer;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.io.KtMaxLoggable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;

public class KtReadPrim
extends KtAssignPrim {
    private transient HashMap<Integer, KtReadInput> table;
    private final KtToken FROZEN_END_READ = new KtFrozenToken("endread", KtCommand.NULL);

    private void initTable() {
        this.table = new HashMap(64);
    }

    public KtReadPrim(String name) {
        super(name);
        this.initTable();
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.initTable();
    }

    public KtReadInput get(int num) {
        return this.table.get(num);
    }

    private KtReadInput replace(int num, KtReadInput input) {
        return this.table.put(num, input);
    }

    public void set(int num, KtReadInput input) {
        KtReadInput old = this.replace(num, input);
        if (old != input && old != KtReadInput.NULL) {
            old.close();
        }
    }

    public boolean eof(int num) {
        return this.get(num) == KtReadInput.NULL;
    }

    @Override
    protected void assign(KtToken src, boolean glob) {
        KtBoolPar canExpand = new KtBoolPar();
        int num = KtReadPrim.scanInt();
        if (!KtReadPrim.scanKeyword("to")) {
            KtReadPrim.error("MissingToForRead");
        }
        KtToken def = KtReadPrim.definableToken();
        KtMacroBody.KtBuffer buf = new KtMacroBody.KtBuffer();
        KtInpTokChecker savedChk = KtReadPrim.setTokenChecker(new KtReadToksChecker(buf, def));
        KtReadInput input = this.get(num);
        int balance = 0;
        int ln = 0;
        if (input == KtReadInput.NULL) {
            input = KtReadPrim.getIOHandler().defaultRead(num);
        }
        do {
            KtToken tok;
            KtReadPrim.getTokStack().push(new KtSentinelToken(this.FROZEN_END_READ));
            KtTokenizer tokenizer = input.nextTokenizer(def, ln++);
            if (tokenizer != KtTokenizer.NULL) {
                KtReadPrim.getTokStack().push(tokenizer);
            } else {
                this.set(num, KtReadInput.NULL);
                tokenizer = input.emptyLineTokenizer();
                KtReadPrim.getTokStack().push(tokenizer);
                if (balance > 0) {
                    KtReadPrim.runAway("definition", buf);
                    KtReadPrim.error("EOFinRead", KtReadPrim.esc("read"));
                    balance = 0;
                }
            }
            while ((tok = KtReadPrim.nextRawToken()) != this.FROZEN_END_READ) {
                if (balance < 0) continue;
                if (tok.matchLeftBrace()) {
                    ++balance;
                } else if (tok.matchRightBrace() && --balance < 0) continue;
                buf.append(tok);
            }
            KtReadPrim.getTokStack().dropPop();
        } while (balance > 0);
        KtReadPrim.setTokenChecker(savedChk);
        def.define(new KtMacro(buf.toMacroBody(), 0), glob);
    }

    static class KtReadToksChecker
    extends KtScanToksChecker {
        public KtReadToksChecker(KtMaxLoggable list, KtLoggable src) {
            super("OuterInDef", "EOFinDef", "definition", list, src);
        }

        @Override
        protected void handleOuterToken(KtToken tok) {
        }
    }

    static class KtSentinelToken
    extends KtTokenizer {
        private final KtToken token;
        private boolean readed = false;

        public KtSentinelToken(KtToken tok) {
            this.token = tok;
        }

        @Override
        public KtToken nextToken(KtBoolPar canExpand) {
            canExpand.set(false);
            if (this.readed) {
                return KtToken.NULL;
            }
            this.readed = true;
            return this.token;
        }

        @Override
        public boolean finishedList() {
            return this.readed;
        }

        @Override
        public int show(KtContextDisplay disp, boolean force, int lines) {
            return 0;
        }
    }
}

