/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.base.KtBoolPar;
import com.whitemagicsoftware.keentype.command.KtBackedToken;
import com.whitemagicsoftware.keentype.command.KtBackedTokenList;
import com.whitemagicsoftware.keentype.command.KtContextDisplay;
import com.whitemagicsoftware.keentype.command.KtFilePos;
import com.whitemagicsoftware.keentype.command.KtInpTokChecker;
import com.whitemagicsoftware.keentype.command.KtInsertedToken;
import com.whitemagicsoftware.keentype.command.KtInsertedTokenList;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.command.KtTokenizer;

public class KtTokenizerStack {
    private KtTokenizer top = KtTokenizer.NULL;
    private KtInpTokChecker checker = KtInpTokChecker.NULL;
    private final KtBoolPar CAN_EXPAND = new KtBoolPar();

    public KtTokenizer getTop() {
        return this.top;
    }

    public synchronized void push(KtTokenizer tokenizer) {
        KtTokenizer oldTop = this.top;
        this.top = tokenizer;
        this.top.pushTo(this, oldTop);
    }

    private synchronized KtTokenizer pop() {
        if (this.top != KtTokenizer.NULL) {
            KtTokenizer oldTop = this.top;
            this.top = oldTop.getNext();
            oldTop.popFrom(this);
            return oldTop;
        }
        return KtTokenizer.NULL;
    }

    public synchronized void dropPop() {
        if (this.top != KtTokenizer.NULL) {
            this.pop().close();
        }
    }

    public synchronized void dropFinishedPop() {
        if (this.top != KtTokenizer.NULL && this.top.finished()) {
            this.pop().close();
        }
    }

    public void push(KtTokenList list, String desc) {
        this.push(new KtInsertedTokenList(list, desc));
    }

    public void backUp(KtTokenList list) {
        this.push(new KtBackedTokenList(list));
    }

    public void push(KtToken tok, String desc) {
        this.push(new KtInsertedToken(tok, desc));
    }

    public void backUp(KtToken tok, boolean exp) {
        this.push(new KtBackedToken(tok, exp));
    }

    public KtInpTokChecker setChecker(KtInpTokChecker chk) {
        KtInpTokChecker old = this.checker;
        this.checker = chk;
        return old;
    }

    public synchronized KtToken nextToken(KtBoolPar canExpand) {
        if (canExpand == KtBoolPar.NULL) {
            canExpand = this.CAN_EXPAND;
        }
        while (this.top != KtTokenizer.NULL) {
            KtToken tok = this.top.nextToken(canExpand);
            if (tok != KtToken.NULL) {
                return this.checker != KtInpTokChecker.NULL ? this.checker.checkToken(tok, canExpand) : tok;
            }
            if (!this.pop().close() || this.checker == KtInpTokChecker.NULL) continue;
            this.checker.checkEndOfFile();
        }
        canExpand.set(false);
        return KtToken.NULL;
    }

    public synchronized void close() {
        while (this.top != KtTokenizer.NULL) {
            this.pop().close();
        }
    }

    public synchronized void cleanFinishedLists() {
        while (this.top != KtTokenizer.NULL && this.top.finishedList()) {
            this.pop().close();
        }
    }

    public synchronized void cleanFinishedInserts() {
        while (this.top != KtTokenizer.NULL && this.top.finishedInsert()) {
            this.pop().close();
        }
    }

    public synchronized void endTopmostInput() {
        for (KtTokenizer curr = this.top; curr != KtTokenizer.NULL && !curr.endInput(); curr = curr.getNext()) {
        }
    }

    public synchronized KtFilePos filePos() {
        KtFilePos pos = KtFilePos.NULL;
        for (KtTokenizer curr = this.top; curr != KtTokenizer.NULL && (pos = curr.filePos()) == KtFilePos.NULL; curr = curr.getNext()) {
        }
        return pos;
    }

    public int lineNumber() {
        KtFilePos pos = this.filePos();
        return pos != KtFilePos.NULL ? pos.line : 0;
    }

    public synchronized void show(KtContextDisplay display) {
        int lines = display.lines();
        boolean dots = lines > 0;
        KtTokenizer curr = this.top;
        if (curr != KtTokenizer.NULL) {
            while (true) {
                boolean force;
                boolean bottom = curr.enoughContext() || curr.getNext() == KtTokenizer.NULL;
                boolean bl = force = bottom || curr == this.top;
                if (force || lines > 0) {
                    display.reset();
                    lines -= curr.show(display, force, lines);
                } else if (dots) {
                    display.normal().startLine().add("...");
                    dots = false;
                }
                if (bottom) break;
                curr = curr.getNext();
            }
        }
    }
}

