/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.io;

import com.whitemagicsoftware.keentype.io.KtCntxLoggable;
import com.whitemagicsoftware.keentype.io.KtCntxLoggableEnum;
import com.whitemagicsoftware.keentype.io.KtLog;

public final class KtCntxLog {
    private final int maxDepth;
    private final int maxCount;
    private final String prefix;
    private int count = 0;

    private KtCntxLog(int md, int mc, String p) {
        this.maxDepth = md;
        this.maxCount = mc;
        this.prefix = p;
    }

    private KtCntxLog(int md, int mc) {
        this.maxDepth = md;
        this.maxCount = mc;
        this.prefix = "";
    }

    public void addItems(KtLog log, KtCntxLoggableEnum items) {
        if (this.prefix.length() <= this.maxDepth) {
            while (this.count <= this.maxCount && items.hasMoreContextLoggables()) {
                log.endLine().add(this.prefix);
                if (this.count++ == this.maxCount) {
                    log.add("etc.");
                    continue;
                }
                items.nextContextLoggable().addOn(log, this);
            }
        } else if (this.count <= this.maxCount && items.hasMoreContextLoggables()) {
            log.add(" []");
        }
    }

    private void addItem(KtLog log, KtCntxLoggable item) {
        if (this.prefix.length() <= this.maxDepth) {
            if (this.count <= this.maxCount) {
                log.endLine().add(this.prefix);
                if (this.count++ == this.maxCount) {
                    log.add("etc.");
                } else {
                    item.addOn(log, this);
                }
            }
        } else if (this.count <= this.maxCount) {
            log.add(" []");
        }
    }

    private KtCntxLog descendant(char p) {
        return new KtCntxLog(this.maxDepth, this.maxCount, this.prefix + p);
    }

    public void addOn(KtLog log, KtCntxLoggableEnum items, char p) {
        this.descendant(p).addItems(log, items);
    }

    public void addOn(KtLog log, KtCntxLoggable item, char p) {
        this.descendant(p).addItem(log, item);
    }

    public void addOn(KtLog log, KtCntxLoggableEnum items) {
        this.addOn(log, items, '.');
    }

    public void addOn(KtLog log, KtCntxLoggable item) {
        this.addOn(log, item, '.');
    }

    public static void addItems(KtLog log, KtCntxLoggableEnum items, int md, int mc) {
        new KtCntxLog(md, mc).addItems(log, items);
    }

    public static void addItem(KtLog log, KtCntxLoggable item, int md, int mc) {
        new KtCntxLog(md, mc).addItem(log, item);
    }
}

