/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.io;

import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import java.io.Serializable;
import java.util.Vector;

public class KtName
implements Serializable,
KtLoggable {
    public static final KtName NULL = null;
    public static final KtName EMPTY = new KtName();
    private final KtCharCode[] codes;

    public KtName(KtCharCode[] codes) {
        this.codes = codes;
    }

    public KtName(KtCharCode code) {
        this.codes = new KtCharCode[1];
        this.codes[0] = code;
    }

    public KtName() {
        this.codes = new KtCharCode[0];
    }

    public final int length() {
        return this.codes.length;
    }

    public KtCharCode codeAt(int index) {
        return this.codes[index];
    }

    public int hashCodeAt(int index) {
        return this.codes[index].hashCode();
    }

    public void getCodes(int beg, int end, KtCharCode[] dst, int offset) {
        while (beg < end) {
            dst[offset++] = this.codes[beg++];
        }
    }

    public void getCodes(KtCharCode[] dst, int offset) {
        this.getCodes(0, this.codes.length, dst, offset);
    }

    public int hashCode() {
        int h = 0;
        if (this.length() > 0) {
            for (int i = this.length() - 1; i >= 0; --i) {
                h = (h << 5) - h + this.hashCodeAt(i);
            }
        }
        return h;
    }

    public final boolean equals(Object o) {
        if (o instanceof KtName) {
            KtName other = (KtName)o;
            if (this.length() == other.length()) {
                for (int i = this.length() - 1; i >= 0; --i) {
                    if (this.codeAt(i).equals(other.codeAt(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean match(KtName n) {
        if (this.length() == n.length()) {
            for (int i = this.length() - 1; i >= 0; --i) {
                if (this.codeAt(i).match(n.codeAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void addOn(KtLog log) {
        log.add(this.codes);
    }

    public void addEscapedOn(KtLog log) {
        log.addEsc().add(this.codes);
    }

    public void addProperlyEscapedOn(KtLog log) {
        switch (this.codes.length) {
            case 0: {
                log.addEsc("csname").addEsc("endcsname");
                break;
            }
            case 1: {
                log.addEsc().add(this.codes[0]);
                if (!this.codes[0].isLetter()) break;
                log.add(' ');
                break;
            }
            default: {
                log.addEsc().add(this.codes).add(' ');
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.length()) {
            buf.append(this.codeAt(i++));
        }
        return buf.toString();
    }

    public static class KtBuffer
    implements Serializable {
        private final Vector<KtCharCode> data;

        public KtBuffer() {
            this.data = new Vector();
        }

        public KtBuffer(int size) {
            this.data = new Vector(size);
        }

        public KtBuffer append(KtCharCode code) {
            this.data.addElement(code);
            return this;
        }

        public KtBuffer append(KtCharCode[] codes, int offset, int count) {
            this.data.ensureCapacity(this.data.size() + count);
            while (count-- > 0) {
                this.data.addElement(codes[offset++]);
            }
            return this;
        }

        public KtBuffer append(KtCharCode[] codes) {
            return this.append(codes, 0, codes.length);
        }

        public KtBuffer append(KtName name) {
            return this.append(name.codes);
        }

        public void clear() {
            this.data.clear();
        }

        public int length() {
            return this.data.size();
        }

        public KtCharCode codeAt(int index) {
            return this.data.elementAt(index);
        }

        public void getCodes(int beg, int end, KtCharCode[] dst, int offset) {
            while (beg < end) {
                dst[offset++] = this.codeAt(beg++);
            }
        }

        public int hashCode() {
            int h = 0;
            if (this.length() > 0) {
                for (int i = this.length() - 1; i >= 0; --i) {
                    h = (h << 5) - h + this.codeAt(i).hashCode();
                }
            }
            return h;
        }

        public final boolean equals(Object o) {
            if (o instanceof KtBuffer) {
                KtBuffer other = (KtBuffer)o;
                if (this.length() == other.length()) {
                    for (int i = this.length() - 1; i >= 0; --i) {
                        if (this.codeAt(i).equals(other.codeAt(i))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public KtName toName() {
            Object[] codes = new KtCharCode[this.length()];
            this.data.copyInto(codes);
            return new KtName((KtCharCode[])codes);
        }
    }
}

